﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

using System.Data.Linq;
using System.Data.Linq.Mapping;

namespace LinqToSqlCwiczenia
{
    public partial class Form2 : Form
    {
        public Form2()
        {
            InitializeComponent();
        }

        [Table(Name="Osoby")]
        class KlasaEncji
        {
            [Column(IsPrimaryKey=true,CanBeNull=false,Name="Id")]
            public int Id;
            [Column(CanBeNull=false)]
            public string Imię;
            [Column(CanBeNull = false)]
            public string Nazwisko;
            [Column(CanBeNull = true)]
            public int? NumerTelefonu;
            [Column(CanBeNull = false)]
            public string Email;
            [Column(CanBeNull = false)]
            public int Wiek;
        }

        //static DataContext bazaDanych = new DataContext(@"Data Source=(LocalDB)\v11.0;AttachDbFilename='C:\Users\pk-8\Documents\Visual Studio 2012\Projects\LinqToSqlCwiczenia\LinqToSqlCwiczenia\Wpisy.mdf';Integrated Security=True");
        static DataContext bazaDanych = new DataContext(@"Data Source=(LocalDB)\v11.0;AttachDbFilename='|DataDirectory|\Wpisy.mdf';Integrated Security=True");
        Table<KlasaEncji> osoby = bazaDanych.GetTable<KlasaEncji>();

        private void Form2_Shown(object sender, EventArgs e)
        {
            var wynikZapytaniaLinq = from KlasaEncji osoba in osoby
                                     orderby osoba.Nazwisko
                                     select osoba.Imię + " " + osoba.Nazwisko + " (" + osoba.Wiek + ")";

            string s = "Lista osób:\n";
            foreach (string personalia in wynikZapytaniaLinq) s += personalia + "\n";
            MessageBox.Show(s);
        }
    }
}
