﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace LinqToSqlCwiczenia
{
    public partial class Form1 : Form
    {
        WpisyDataContext bazaDanych = new WpisyDataContext();
        bool czySiatkaEdytowana = false;

        public Form1()
        {
            InitializeComponent();

            osobaBindingSource.DataSource = bazaDanych.Osobas;
            czySiatkaEdytowana = false;
        }

        private void Form1_FormClosing(object sender, FormClosingEventArgs e)
        {
            if (!czySiatkaEdytowana) return;

            DialogResult dr = MessageBox.Show(
                "Dane zostały zmienione. Czy zapisać zmiany do bazy danych?",
                Text,
                MessageBoxButtons.YesNoCancel,
                MessageBoxIcon.Question);

            switch (dr)
            {
                case DialogResult.Yes:
                    bazaDanych.SubmitChanges();
                    break;
                case DialogResult.No:
                    break;
                case DialogResult.Cancel:
                    e.Cancel = true;
                    break;
            }
        }

        private void osobaDataGridView_CellValueChanged(object sender, DataGridViewCellEventArgs e)
        {
            czySiatkaEdytowana = true;                          
        }

        private void Form1_Shown(object sender, EventArgs e)
        {
            new Form2().Show();
        }

        private void button1_Click(object sender, EventArgs e)
        {
            IEnumerable<ProcedureResult> wynikProcedurySkladowanej = bazaDanych.Procedure();

            string s = "Lista osób <30:\n";
            foreach (ProcedureResult pr in wynikProcedurySkladowanej) s += pr.Imię + " " + pr.Nazwisko + " (" + pr.Wiek.ToString() + ")\n";
            MessageBox.Show(s);
        }

        private void button2_Click(object sender, EventArgs e)
        {
            var wynikZapytaniaLinq = from Osoba osoba in bazaDanych.Osobas
                                     where osoba.Wiek<30
                                     orderby osoba.Nazwisko, osoba.Imię
                                     select osoba;

            string s = "Lista osób <30:\n";
            foreach (Osoba o in wynikZapytaniaLinq) s += o.Imię + " " + o.Nazwisko + " (" + o.Wiek.ToString() + ")\n";
            MessageBox.Show(s);

            dataGridView1.DataSource = wynikZapytaniaLinq;
        }        
    }

    /*
    static class Rozszerzenia
    {
        public static string ToString(this Osoba osoba)
        {
            return osoba.Imię + " " + osoba.Nazwisko;            
        }
    }
    */
}
