﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace LinqToObjects
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }

        public struct Wpis
        {
            private string nazwaUżytkownika;
            private string treść;
            private DateTime data;
            private string adresIP;

            public string NazwaUżytkownika { get { return nazwaUżytkownika; } }
            public string Treść { get { return treść; } }
            public DateTime Data { get { return data; } }
            public string AdresIP { get { return adresIP; } }

            public Wpis(string nazwaUżytkownika, string treść, DateTime data, string adresIP)
            {
                this.nazwaUżytkownika = nazwaUżytkownika;
                this.treść = treść;
                this.data = data;
                this.adresIP = adresIP;
            }

            public override string ToString()
            {
                return NazwaUżytkownika + " " + Treść + " (" + Data + ")";
            }
        }

        private void button1_Click(object sender, EventArgs e)
        {
            List<Wpis> wpisy = new List<Wpis>();
            wpisy.Add(new Wpis("Jacek","pan domu",DateTime.Now,"158.75.4.9"));
            wpisy.Add(new Wpis("Bartek", "syn", DateTime.Now.AddDays(5), "158.75.4.9"));
            wpisy.Add(new Wpis("Kasia", "żona", DateTime.Now.AddDays(10), "158.75.4.10"));
            wpisy.Add(new Wpis("Karolina", "córka", DateTime.Now.AddDays(2), "158.75.4.9"));
            

            /*
            String s = "";
            for (int i = 0; i < wpisy.Count; ++i)
            {
                s += wpisy[i].ToString() + "\n";
            }
            MessageBox.Show(s);
            */

            String s = "Wszystkie:\n";
            foreach (Wpis wpis in wpisy)
            {
                s += wpis.ToString() + "\n";
            }
            MessageBox.Show(s);

            var wynikZapytania1 = from Wpis wpis in wpisy
                                 where !wpis.NazwaUżytkownika.EndsWith("a")
                                 select wpis.NazwaUżytkownika + " " + wpis.Data.ToShortDateString();

            var wynikZapytania = from Wpis wpis in wpisy
                                 where wpis.Data>DateTime.Now
                                 orderby wpis.Data descending 
                                 select wpis;



            s = "Wybrane:\n";
            foreach (var element in wynikZapytania)
            {
                s += element.ToString() + "\n";
            }
            MessageBox.Show(s);
        }
    }
}
