﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;

using KsiegaGosci_MVC.Models;

namespace KsiegaGosci_MVC.Controllers
{
    public class KsiegaGosciController : Controller
    {
        //
        // GET: /KsiegaGosci/

        private const string nazwaPlikuXml = "C:\\Prywatne\\Wpisy.xml";
        private Wpisy wpisy = new Wpisy(nazwaPlikuXml);

        [HttpGet]
        public ActionResult Index()
        {
            return View(wpisy);
        }

        [HttpPost]
        public ActionResult Index(FormCollection formularz)
        {
            string nazwaUżytkownika = formularz["TextBox1"];
            string treśćWpisu = formularz["TextBox2"];

            if (nazwaUżytkownika != "" && treśćWpisu != "") //walidacja po stronie serwera
            {
                //uzupełniamy dane modelu
                Wpis nowyWpis = new Wpis(nazwaUżytkownika, treśćWpisu, DateTime.Now, Request.UserHostAddress);
                wpisy.Dodaj(nowyWpis);

                zapamiętajNazwęUżytkownika(nazwaUżytkownika);
                ViewData.Add("nazwaOstatniegoUżytkownika", nazwaUżytkownika);
            }

            return View(wpisy);
        }

        #region Obsługa ciasteczek
        const string idNazwaUżytkownika = "nazwaUżytkownika";

        void zapamiętajNazwęUżytkownika(string nazwaUżytkownika)
        {
            HttpCookie ciasteczko = new HttpCookie(idNazwaUżytkownika, nazwaUżytkownika);
            ciasteczko.Expires = DateTime.Now.AddDays(3);
            Response.Cookies.Add(ciasteczko);
        }

        string przypomnijNazwęUżytkownika()
        {
            if (Request.Cookies[idNazwaUżytkownika] != null) return Request.Cookies[idNazwaUżytkownika].Value;
            else return null;
        }
        #endregion
    }
}
