﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.SessionState;

using System.IO;
using System.Web.UI;

namespace KsięgaGości
{
    public class Global : System.Web.HttpApplication
    {
        //public const string idWpisy = "wpisy";

        protected void Application_Start(object sender, EventArgs e)
        {
            DopiszDoRejestruZdarzeń("Aplikacja została uruchomiona");
            ScriptManager.ScriptResourceMapping.AddDefinition("jquery",
                new ScriptResourceDefinition
                {
                    Path = "~/Scripts/jquery-2.0.3.min.js",
                    DebugPath = "~/Scripts/jquery-2.0.3.min.js",
                    CdnPath = "http://ajax.microsoft.com/ajax/jQuery/jquery-2.0.3.min.js",
                    CdnDebugPath = "http://ajax.microsoft.com/ajax/jQuery/jquery-2.0.3.min.js"
                });

            //Application.Add(idWpisy, new Wpisy(nazwaPlikuXml)); //to musi być pierwszy, przed czytaniem            
        }

        protected void Session_Start(object sender, EventArgs e)
        {
            DopiszDoRejestruZdarzeń("Start sesji, użytkownik: " + Request.UserHostAddress);
        }

        protected void Application_BeginRequest(object sender, EventArgs e)
        {            
        }

        protected void Application_AuthenticateRequest(object sender, EventArgs e)
        {

        }

        protected void Application_Error(object sender, EventArgs e)
        {
            DopiszDoRejestruZdarzeń("Błąd w sesji " + Request.UserHostAddress);
        }

        protected void Session_End(object sender, EventArgs e)
        {
            DopiszDoRejestruZdarzeń("Koniec sesji, użytkownik: " + Request.UserHostAddress);
        }

        protected void Application_End(object sender, EventArgs e)
        {
            DopiszDoRejestruZdarzeń("Zamknięcie aplikacji");
        }

        private const string nazwaPlikuTxt = "C:\\Prywatne\\RejestrZdarzeń.txt";        

        public static bool DopiszDoRejestruZdarzeń(string wpis)
        {
            try
            {
                //if (File.Exists(nazwaPlikuTxt)) File.Copy(nazwaPlikuTxt, nazwaPlikuTxt + ".bak",true);
                using (StreamWriter sw = new StreamWriter(nazwaPlikuTxt, true))
                {
                    sw.WriteLine(DateTime.Now.ToString() + ": " + wpis);
                }
                return true;
            }
            catch
            {
                return false;
            }
        }
    }
}