﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Runtime.Serialization;
using System.ServiceModel;
using System.Text;

namespace KsięgaGości.BibliotekaUslug
{
    /*
    [DataContract]
    public struct Wpis
    {
        //private Model.Wpis wpisModel;

        [DataMember] public string NazwaUżytkownika;
        [DataMember] public string Treść;
        [DataMember] public DateTime Data;
        [DataMember] public string AdresIP;

        public Wpis(string nazwaUżytkownika, string treść, DateTime data, string adresIP)
        {
            this.NazwaUżytkownika = nazwaUżytkownika;
            this.Treść = treść;
            this.Data = data;
            this.AdresIP = adresIP;
        }
    }
    */

    //*
    //kontrakt danych
    [DataContract]
    public struct Wpis
    {
        //nie można dziedziczyć po klasie Model.Wpis
        //można współdzielić plik w obu projektach
        //tu robię kopię klasy encji z modelu z rzutowaniami
        //ponieważ klasa encji nie ma setterów, muszę tu trzymać kopię własności zamiast po prostu zawrzeć Model.Wpis jako pole prywatne

        [DataMember] public string NazwaUżytkownika;
        [DataMember] public string Treść;
        [DataMember] public DateTime Data;
        [DataMember] public string AdresIP;

        //konwersja implicit z Wpis do Model.Wpis
        public static implicit operator Model.Wpis(Wpis wpis)
        {
            return new Model.Wpis(wpis.NazwaUżytkownika, wpis.Treść, wpis.Data, wpis.AdresIP); ;
        }

        //konwersja implicit z Model.Wpis do Wpis
        public static implicit operator Wpis(Model.Wpis wpisModel)
        {
            return new Wpis(wpisModel);
        }

        public Wpis(string nazwaUżytkownika, string treść, DateTime data, string adresIP)
            :this()
        {
            this.NazwaUżytkownika = nazwaUżytkownika;
            this.Treść = treść;
            this.Data = data;
            this.AdresIP = adresIP;
        }

        private Wpis(Model.Wpis wpisModel)
        {
            this.NazwaUżytkownika = wpisModel.NazwaUżytkownika;
            this.Treść = wpisModel.Treść;
            this.Data = wpisModel.Data;
            this.AdresIP = wpisModel.AdresIP;
        }
    }
    //*/
      
    //kontrakt usługi
    [ServiceContract]
    public interface IUslugaWpisy
    {
        [OperationContract]
        int PobierzLiczbęWpisów();

        [OperationContract]
        void DodajWpis(Wpis nowyWpis);

        [OperationContract]
        Wpis[] PobierzWszystkieWpisy();
    }
}
