﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Runtime.Serialization;
using System.ServiceModel;
using System.Text;

namespace KsięgaGości.BibliotekaUslug
{
    //kontrakt danych
    [DataContract]
    public struct Wpis
    {
        //nie można dziedziczyć po klasie Model.Wpis
        //można współdzielić plik w obu projektach
        //tu robię wrapper do klasy encji z modelu
        private Model.Wpis wpisModel;

        //nie udostępniane
        public Model.Wpis WpisModel { get { return wpisModel; } }

        //konwersja implicit z Wpis do Model.Wpis
        public static implicit operator Model.Wpis(Wpis wpis)
        {
            return wpis.WpisModel;
        }

        //konwersja implicit z Model.Wpis do Wpis
        public static implicit operator Wpis(Model.Wpis wpisModel)
        {
            return new Wpis(wpisModel);
        }

        [DataMember]
        public string NazwaUżytkownika { get { return wpisModel.NazwaUżytkownika; } }
        [DataMember]
        public string Treść { get { return wpisModel.Treść; } }
        [DataMember]
        public DateTime Data { get { return wpisModel.Data; } }
        [DataMember]
        public string AdresIP { get { return wpisModel.AdresIP; } }

        public Wpis(string nazwaUżytkownika, string treść, DateTime data, string adresIP)
            :this()
        {
            wpisModel = new Model.Wpis(nazwaUżytkownika, treść, data, adresIP);            
        }

        private Wpis(Model.Wpis wpisModel)
        {
            this.wpisModel = wpisModel;
        }
    }

    //kontrakt usługi
    [ServiceContract]
    public interface IUslugaWpisy
    {
        [OperationContract]
        int PobierzLiczbęWpisów();

        [OperationContract]
        void DodajWpis(Wpis nowyWpis);

        [OperationContract]
        Wpis[] PobierzWszystkieWpisy();
    }
}
