﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.SessionState;

using System.IO;

namespace KsięgaGości
{
    public class Global : System.Web.HttpApplication
    {
        public const string idWpisy = "wpisy";

        /*
        public static string idWpisy2
        {
            get
            {
                return "wpisy";
            }
        }
        */

        protected void Application_Start(object sender, EventArgs e)
        {
            Application.Add(idWpisy, new Wpisy(nazwaPlikuXml)); //to musi być pierwszy, przed czytaniem
            //WczytajWpisyZPlikuTekstowego();
        }

        protected void Session_Start(object sender, EventArgs e)
        {

        }

        protected void Application_BeginRequest(object sender, EventArgs e)
        {

        }

        protected void Application_AuthenticateRequest(object sender, EventArgs e)
        {

        }

        protected void Application_Error(object sender, EventArgs e)
        {

        }

        protected void Session_End(object sender, EventArgs e)
        {

        }

        protected void Application_End(object sender, EventArgs e)
        {

        }

        private const string nazwaPlikuTxt = "C:\\Prywatne\\Wpisy.txt";
        private const string nazwaPlikuXml = "C:\\Prywatne\\Wpisy.xml";

        public static bool DopiszWpisDoPlikuTekstowego(string wpis)
        {
            try
            {
                if (File.Exists(nazwaPlikuTxt)) File.Copy(nazwaPlikuTxt, nazwaPlikuTxt + ".bak",true);
                using (StreamWriter sw = new StreamWriter(nazwaPlikuTxt, true))
                {
                    sw.WriteLine(wpis);
                }
                return true;
            }
            catch
            {
                return false;
            }
        }

        public bool WczytajWpisyZPlikuTekstowego()
        {
            if (!File.Exists(nazwaPlikuTxt)) return false;

            List<string> wpisy = (List<string>)Application[idWpisy];

            try
            {
                using (StreamReader sr = new StreamReader(nazwaPlikuTxt))
                {
                    string wpis;
                    while ((wpis = sr.ReadLine()) != null)
                    {
                        wpisy.Add(wpis);
                    }
                }
                return true;
            }
            catch
            {
                return false;
            }
        }
    }
}