﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace KsięgaGości
{
    public partial class WebForm1 : System.Web.UI.Page
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            wyświetlWpisy();
        }

        protected void Page_Init(object sender, EventArgs e)
        {
            if (TextBox1.Text == "")
            {
                string nazwaUżytkownika = przypomnijNazwęUżytkownika();
                if (nazwaUżytkownika != null) TextBox1.Text = nazwaUżytkownika;
            }
            //javascript:alert(document.cookie)
        }        

        void wyświetlWpisy()
        {
            List<string> wpisy = (List<string>)Application[Global.idWpisy];

            Label1.Text="Wpisy:<P>";
            /*
            foreach (string wpis in wpisy)
            {
                Label1.Text += wpis + "<P>";
            }
            */
            for (int i = 0; i < wpisy.Count; ++i)
            {
                Label1.Text += "<FONT COLOR=\"" + ((i % 2 == 0) ? "blue" : "navy") + "\">";
                Label1.Text += wpisy[i] + "<P>";
                Label1.Text += "</FONT>";
            }
        }

        protected void Button1_Click(object sender, EventArgs e)
        {
            String nazwaUżytkownika = TextBox1.Text;
            String treśćWpisu = TextBox2.Text.Replace("\r","").Replace("\n","<BR>");            

            zapamiętajNazwęUżytkownika(nazwaUżytkownika);

            String wpis = "<B>"+nazwaUżytkownika+"</B><BR>";
            wpis += treśćWpisu + "<BR>";
            wpis += "Dodano " + DateTime.Now.ToString() + " z komputera <I>" + Request.UserHostAddress + "</I>";

            List<string> wpisy = (List<string>)Application[Global.idWpisy];
            wpisy.Add(wpis);
            Global.DopiszWpisDoPlikuTekstowego(wpis);

            wyświetlWpisy();
        }

        const string idNazwaUżytkownika = "nazwaUżytkownika";

        void zapamiętajNazwęUżytkownika(string nazwaUżytkownika)
        {
            HttpCookie ciasteczko = new HttpCookie(idNazwaUżytkownika, nazwaUżytkownika);
            ciasteczko.Expires = DateTime.Now.AddDays(3);
            Response.Cookies.Add(ciasteczko);
        }

        string przypomnijNazwęUżytkownika()
        {
            if (Request.Cookies[idNazwaUżytkownika] != null) return Request.Cookies[idNazwaUżytkownika].Value;
            else return null;
        }
    }
}