﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

using System.Xml.Linq; //LINQ to XML

namespace DrzewoXml
{
    public partial class Default : System.Web.UI.Page
    {
        //string ścieżkaPlikuXml = @"C:\Prywatne\Wpisy.xml";
        string ścieżkaPlikuXml = "http://www.nbp.pl/kursy/xml/LastC.xml";

        protected void Page_Load(object sender, EventArgs e)
        {
            WczytajXmlDoDrzewa(ścieżkaPlikuXml);
        }

        void DodajElementXmlDoWęzłaDrzewa(TreeNode węzełDrzewa, XElement elementXml)
        {
            foreach (XElement podElementXml in elementXml.Elements())
            {
                string wartość = "";
                if (podElementXml.Elements().Count() == 0) wartość = " (" + podElementXml.Value + ")";
                TreeNode podWęzełDrzewa = new TreeNode(podElementXml.Name.LocalName + wartość);                
                DodajElementXmlDoWęzłaDrzewa(podWęzełDrzewa, podElementXml);
                węzełDrzewa.ChildNodes.Add(podWęzełDrzewa);
            }
        }

        private void WczytajXmlDoDrzewa(string ścieżkaPlikuXml)
        {
            try
            {
                XDocument xml = XDocument.Load(ścieżkaPlikuXml);

                TreeNode węzełGłówny = new TreeNode(xml.Root.Name.LocalName);
                DodajElementXmlDoWęzłaDrzewa(węzełGłówny, xml.Root);
                treeView1.Nodes.Add(węzełGłówny);

                treeView1.ExpandAll();
            }
            catch
            {
                //nie reaguję na błąd
            }
        }
    }
}