﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using System.Threading;

namespace Zadania
{
    class Program
    {
        const int liczbaZadan = 100;

        static void Main(string[] args)
        {
            //TworzenieZadan();

            /*
            Console.WriteLine("Podaj liczbę: ");
            int n = Int32.Parse(Console.ReadLine());
            TestLiczbyPierwszej(n);
            */

            //SztafetaZadan();

            PrzerywanieZadan();

            //PrzerywanieOczekiwania();
        }

        static void TworzenieZadan()
        {
            /*
            Task t = new Task( () => Console.WriteLine("Thread ID: " + Thread.CurrentThread.ManagedThreadId+", Task ID: "+Task.CurrentId));
            t.Start();
            t.Wait();
            */

            Func<String> a =
                () =>
                {
                    Console.WriteLine("Thread ID: " + Thread.CurrentThread.ManagedThreadId + ", Task ID: " + Task.CurrentId);
                    Thread.SpinWait(1000);
                    Console.WriteLine("Koniec (" + Task.CurrentId + ")");
                    return Task.CurrentId.HasValue ? Task.CurrentId.ToString() : "UI";
                };
            List<Task<String>> listaZadan = new List<Task<String>>();

            for (int i = 0; i < liczbaZadan; ++i) listaZadan.Add(new Task<String>(a));
            listaZadan.ForEach(_t => _t.Start());
            //listaZadan.ForEach(_t => _t.Wait());
            listaZadan.ForEach(_t => Console.WriteLine("Indeks zadania: " + _t.Result));

        }

        static bool TestLiczbyPierwszej(int liczba)
        {
            List<Task<int>> lista = new List<Task<int>>();            
            int n=liczba;

            for (int i = 2; i < (int)Math.Sqrt(n); ++i)
            {
                lista.Add(new Task<int>(
                    (object j)=>
                        {
                            int _j = (int)j;
                            if(n%_j==0) return _j;
                            else return 0;
                        },i));
            }

            foreach (Task<int> t in lista) t.Start();
            //foreach (Task<int> t in lista) t.Wait();
            Task.WaitAll(lista.ToArray());

            bool pierwsza = true;
            foreach (Task<int> t in lista)
            {
                if (t.Result != 0)
                {
                    Console.WriteLine("Liczba {0} dzieli się przez {1}.", n, t.Result);
                    pierwsza = false;
                }
            }
            if (pierwsza) Console.WriteLine("Liczba {0} jest liczba pierwszą.", n);
            return pierwsza;
        }

        static void SztafetaZadan()
        {
            Task t1, t2, t3, t4;
            Action a =
                () =>
                {
                    Console.WriteLine("Zawodnik nr {0} wystartował w wątku {1}", Task.CurrentId, Thread.CurrentThread.ManagedThreadId);
                    Task.Delay(new Random().Next(1000, 5000)).Wait();
                    Console.WriteLine("Zawodnik nr {0} zakończył bieg w wątku {1}", Task.CurrentId, Thread.CurrentThread.ManagedThreadId);
                };

            Action<Task> b =
                (t) =>
                {
                    Console.WriteLine("Zawodnik' nr {0} wystartował po zawodniku {1} w wątku {2}", Task.CurrentId, t.Id, Thread.CurrentThread.ManagedThreadId);
                    Task.Delay(new Random().Next(1000, 2000)).Wait();
                    Console.WriteLine("Zawodnik' nr {0} zakończył bieg w wątku {1}", Task.CurrentId, Thread.CurrentThread.ManagedThreadId);
                };

            t1 = new Task(a);
            t2 = new Task(a);
            t3 = t1.ContinueWith(b, TaskContinuationOptions.ExecuteSynchronously);
            t4 = t2.ContinueWith(b, TaskContinuationOptions.ExecuteSynchronously);

            t1.Start();
            t2.Start();
            
            //int indeksZwyciezcy = Task.WaitAny(t3, t4);
            //Console.WriteLine("Wyścig wygrał "+indeksZwyciezcy);
            Task.WhenAny(t3,t4).ContinueWith((_t)=>Console.WriteLine("Zwyciężył {0}",_t.Id),TaskContinuationOptions.ExecuteSynchronously);

            Task.WaitAll(/*t1, t2,*/ t3, t4);
            Console.WriteLine("Wyścig zakończony");
            //?Task.WhenAll(t3, t4).ContinueWith((_t) => Console.WriteLine("Wyścig zakończony"));
        }

        static void PrzerywanieZadan()
        {
            CancellationTokenSource cts = new CancellationTokenSource();
            CancellationToken ct = cts.Token;

            Task t = new Task(
                () =>
                    {
                        try
                        {
                            Console.WriteLine("Zadanie zostało uruchomione");
                            for(;;)
                            {
                                ct.ThrowIfCancellationRequested();
                            }
                        }
                        catch(ArgumentException exc)
                        {
                            Console.WriteLine("Zadanie zostało przerwane - "+exc.Message);
                        }
                    }, ct);
                t.Start();

                Console.WriteLine("Stan zadania: " + t.Status.ToString());
                Task.Delay(1000).Wait();
                cts.Cancel();
                Console.WriteLine("Stan zadania: " + t.Status.ToString());
                try
                {
                    Console.WriteLine("Stan zadania: " + t.Status.ToString());
                    t.Wait(); //czy Wait odbiera wyjatek
                }
                catch (AggregateException exc)
                {
                    Console.WriteLine("Stan zadania: " + t.Status.ToString());
                    Console.WriteLine("Wyjątek z zadania: " + exc.Flatten().InnerExceptions[0].Message);
                }                

                Console.WriteLine("Stan zadania: " + t.Status.ToString());
                Console.WriteLine("Naciśnij Enter..."); Console.ReadLine();
                Console.WriteLine("Stan zadania: " + t.Status.ToString());
        }

        static void PrzerywanieOczekiwania()
        {
            CancellationTokenSource cts = new CancellationTokenSource();
            CancellationToken ct = cts.Token;

            Task t = new Task(
                () =>
                {
                    Console.WriteLine("Zadanie zostało uruchomione");
                    for (; ; )
                    {
                        Thread.Sleep(1000);
                        cts.Cancel();
                    }
                });

            t.Start();

            Task[] zadania = { t };
            try
            {
                Task.WaitAll(zadania, ct);
            }
            catch (OperationCanceledException)
            {
                Console.WriteLine("Przerwano oczekiwanie");
            }

            //Task.WaitAll(zadania); //zadanie nigdy sie nie konczy
            //Console.WriteLine("Ostateczne czekanie");
        }

    }
}
