﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using System.Threading;

namespace Watki
{
    class Program
    {        
        static Random r=new Random();

        //static int ilośćWątków = System.Environment.ProcessorCount;        
        static object obiektSynchronizacji = new object();
        static long ilośćTrafień = 0;
        const int liczbaWątków = 5;
        const long ilośćPróbWWątku = 10000000;
        static long ilośćZrealizowanychPrób = 0;

        private static EventWaitHandle[] ewh = new EventWaitHandle[liczbaWątków];

        private static void raport(object state)
        {
            Console.WriteLine(ilośćZrealizowanychPrób.ToString() + "/" + (liczbaWątków * ilośćPróbWWątku).ToString() + " (" + (100.0 * ilośćZrealizowanychPrób / (liczbaWątków * ilośćPróbWWątku)).ToString() + "%)");
        }

        private static void raportWatek(object parametr)
        {
            int delay = (int)parametr;
            try
            {
                do
                {
                    Console.WriteLine(ilośćZrealizowanychPrób.ToString() + "/" + (liczbaWątków * ilośćPróbWWątku).ToString() + " (" + (100.0 * ilośćZrealizowanychPrób / (liczbaWątków * ilośćPróbWWątku)).ToString() + "%)");
                    Thread.Sleep(delay);
                }
                while (true);
            }
            catch (ThreadAbortException exc)
            {
                Console.WriteLine("Koniec: " + ilośćZrealizowanychPrób.ToString() + "/" + (liczbaWątków * ilośćPróbWWątku).ToString() + " (" + (100.0 * ilośćZrealizowanychPrób / (liczbaWątków * ilośćPróbWWątku)).ToString() + "%)");
            }
        }

        static void Main(string[] args)
        {
            /*
            Thread[] tt = new Thread[ilośćWątków];
            for(int i=0;i<ilośćWątków;++i)
            {
                Thread t = new Thread(uruchomObliczenia);
                t.Start(ct);
                t.IsBackground = true;
                t.Priority = ThreadPriority.Lowest;
                tt[i] = t;
            }
            */
            for (int i = 0; i < liczbaWątków; ++i)
            {
                ewh[i] = new EventWaitHandle(false, EventResetMode.AutoReset);
                ThreadPool.QueueUserWorkItem(uruchomObliczenia, i);                
            }

            //System.Threading.Timer timer=new System.Threading.Timer(raport,null,1000,1000);
            Thread watekRaportu = new Thread(raportWatek);
            watekRaportu.IsBackground=true;
            watekRaportu.Priority=ThreadPriority.AboveNormal;
            watekRaportu.Start(1000);

            /*
            //wait all
            for (int i = 0; i < ilośćWątków; ++i)
            {
                tt[i].Join();
            }
            */
            foreach (var element in ewh) element.WaitOne();

            //watekRaportu.Abort();

            double pi = 4.0 * ilośćTrafień / (liczbaWątków * ilośćPróbWWątku);
            Console.WriteLine("Pi=" + pi.ToString());            

            Console.WriteLine("\nKoniec.");
        }

        static bool obliczPi(long ilośćPrób)
        {
            Random r = new Random(Program.r.Next() + Thread.CurrentThread.ManagedThreadId);

            try
            {
                for (long i = 0; i < ilośćPrób; ++i)
                {
                    double x = r.NextDouble();
                    double y = r.NextDouble();
                    if (x * x + y * y < 1)
                    {
                        Interlocked.Increment(ref ilośćTrafień);
                    }
                    Interlocked.Increment(ref ilośćZrealizowanychPrób);
                }
                return true;
            }
            catch (ThreadAbortException tae)
            {
                Console.ForegroundColor = ConsoleColor.Red;
                Console.WriteLine("Watek zostanie brutalnie zakończony metodą Abort: " + tae.Message);
                return false;
            }
            catch (Exception exc)
            {
                Console.ForegroundColor = ConsoleColor.Yellow;
                Console.WriteLine("Wystąpił błąd w metodzie wątku: " + exc.Message);
                return false;
            }            
        }

        static void uruchomObliczenia(object parametr)
        {
            int indeks = (int)parametr;

            long start = System.Environment.TickCount;
            
            Console.WriteLine("Uruchamiam obliczenia w wątku " + Thread.CurrentThread.ManagedThreadId.ToString());
            if (obliczPi(ilośćPróbWWątku))
            {
                long czasTrwania = System.Environment.TickCount - start;
                Console.WriteLine("Obliczenia zakończone w wątku " + Thread.CurrentThread.ManagedThreadId.ToString() + " po " + czasTrwania + "ms");
            }
            else
            {
                Console.WriteLine("Obliczenia przerwane");
            }

            ewh[indeks].Set();
        }
    }
}
