﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using System.Threading;

namespace Watki
{
    class Program
    {        
        static Random r=new Random();
        //static bool zakonczWatek = false;
        //static bool wstrzymajWatek = false;

        static int ilośćWątków = System.Environment.ProcessorCount;        

        static object obiektSynchronizacji = new object();
        static long ilośćTrafień = 0;
        const long ilośćPróbWWątku = 100000000;

        static void Main(string[] args)
        {
            //uruchomObliczenia();

            CancellationTokenSource cts = new CancellationTokenSource();
            CancellationToken ct=cts.Token;

            Thread[] tt = new Thread[ilośćWątków];
            for(int i=0;i<ilośćWątków;++i)
            {
                Thread t = new Thread(uruchomObliczenia);
                t.Start(ct);
                t.IsBackground = true;
                t.Priority = ThreadPriority.Lowest;
                tt[i] = t;
            }

            /*
            Thread.Sleep(2000);
            Console.WriteLine("Usypiam wątek dodatkowy...");
            //t.Suspend(); //przestarzałe
            wstrzymajWatek = true;
            Thread.Sleep(2000);
            //t.Resume(); //przestarzałe
            wstrzymajWatek = false;
            Console.WriteLine("Wznawiam wątek dodatkowy...");
            */

            /*
            Console.WriteLine("Naciśnij Enter aby zakończyć wątek główny");
            Console.ReadLine();
            Console.WriteLine("Naciśnięty Enter");
            */

            //t.Abort();
            //lock (r) { zakonczWatek = true; }
            //cts.Cancel();      

            //wait all
            for (int i = 0; i < ilośćWątków; ++i)
            {
                tt[i].Join();
            }

            double pi = 4.0 * ilośćTrafień / (ilośćWątków * ilośćPróbWWątku);
            Console.WriteLine("Pi=" + pi.ToString());

            Console.WriteLine("\nKoniec.");
        }

        static bool obliczPi(long ilośćPrób,CancellationToken ct)
        {
            Random r = new Random(Program.r.Next() + Thread.CurrentThread.ManagedThreadId);

            try
            {
                for (long i = 0; i < ilośćPrób; ++i)
                {
                    //Console.Write("*");
                    
                    //zamykanie watku
                    //lock (r) { if (zakonczWatek) return -1; } //słaby punkt
                    //ct.ThrowIfCancellationRequested();
                    if (ct.IsCancellationRequested) return false;

                    /*
                    //wstrzymywanie watku
                    while (wstrzymajWatek)
                    {
                        Thread.Sleep(10);
                    }
                    */

                    double x = r.NextDouble();
                    double y = r.NextDouble();
                    if (x * x + y * y < 1)
                    {
                        //ilośćTrafień++; //źle
                        //lock (obiektSynchronizacji) { ilośćTrafień++; } //dobrze, ale wolno
                        Interlocked.Increment(ref ilośćTrafień);
                    }
                }
                return true;
            }
            catch (ThreadAbortException tae)
            {
                Console.ForegroundColor = ConsoleColor.Red;
                Console.WriteLine("Watek zostanie brutalnie zakończony metodą Abort: " + tae.Message);
                return false;
            }
            catch (Exception exc)
            {
                Console.ForegroundColor = ConsoleColor.Yellow;
                Console.WriteLine("Wystąpił błąd w metodzie wątku: " + exc.Message);
                return false;
            }            
        }

        static void uruchomObliczenia(object parametr)
        {
            long start = System.Environment.TickCount;
            CancellationToken ct = (CancellationToken)parametr;
            
            Console.WriteLine("Uruchamiam obliczenia w wątku " + Thread.CurrentThread.ManagedThreadId.ToString());
            if (obliczPi(ilośćPróbWWątku, ct))
            {
                long czasTrwania = System.Environment.TickCount - start;
                Console.WriteLine("Obliczenia zakończone w wątku " + Thread.CurrentThread.ManagedThreadId.ToString() + " po " + czasTrwania + "ms");
            }
            else
            {
                Console.WriteLine("Obliczenia przerwane");
            }
            /*
            if (pi == -1) Console.WriteLine("Działanie wątku zakończyło się przedwcześnie");
            else
            {
                Console.WriteLine("Pi=" + pi);
                Console.WriteLine("Obliczenia zakończone");
            }
            */
            
        }
    }
}
