﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using System.Threading;

namespace Watki
{
    class Program
    {
        static Random r=new Random();
        static bool zakonczWatek = false;
        static bool wstrzymajWatek = false;

        static void Main(string[] args)
        {
            //uruchomObliczenia();

            CancellationTokenSource cts = new CancellationTokenSource();
            CancellationToken ct=cts.Token;

            Thread t = new Thread(uruchomObliczenia);
            t.Start(ct);
            t.IsBackground = true;
            t.Priority = ThreadPriority.Lowest;

            /*
            Thread.Sleep(2000);
            Console.WriteLine("Usypiam wątek dodatkowy...");
            //t.Suspend(); //przestarzałe
            wstrzymajWatek = true;
            Thread.Sleep(2000);
            //t.Resume(); //przestarzałe
            wstrzymajWatek = false;
            Console.WriteLine("Wznawiam wątek dodatkowy...");
            */

            Console.WriteLine("Naciśnij Enter aby zakończyć wątek główny");
            Console.ReadLine();
            Console.WriteLine("Naciśnięty Enter");
            //t.Abort();
            //lock (r) { zakonczWatek = true; }
            //cts.Cancel();      

            t.Join();

            Console.WriteLine("\nKoniec.");
        }

        static double obliczPi(long ilośćPrób,CancellationToken ct)
        {
            try
            {
                long ilośćTrafień = 0;
                for (long i = 0; i < ilośćPrób; ++i)
                {
                    //Console.Write("*");
                    
                    //zamykanie watku
                    //lock (r) { if (zakonczWatek) return -1; } //słaby punkt
                    //ct.ThrowIfCancellationRequested();
                    if (ct.IsCancellationRequested) return -1;

                    //wstrzymywanie watku
                    while (wstrzymajWatek)
                    {
                        Thread.Sleep(10);
                    }

                    double x = r.NextDouble();
                    double y = r.NextDouble();
                    if (x * x + y * y < 1) ilośćTrafień++;
                }
                return 4.0 * ilośćTrafień / ilośćPrób;
            }
            catch (ThreadAbortException tae)
            {
                Console.ForegroundColor = ConsoleColor.Red;
                Console.WriteLine("Watek zostanie brutalnie zakończony metodą Abort: " + tae.Message);                
            }
            catch (Exception exc)
            {
                Console.ForegroundColor = ConsoleColor.Yellow;
                Console.WriteLine("Wystąpił błąd w metodzie wątku: " + exc.Message);
            }
            return -1;
        }

        static void uruchomObliczenia(object parametr)
        {
            CancellationToken ct = (CancellationToken)parametr;
            
            Console.WriteLine("Uruchamiam obliczenia...");
            double pi = obliczPi(100000000, ct);
            if (pi == -1) Console.WriteLine("Działanie wątku zakończyło się przedwcześnie");
            else
            {
                Console.WriteLine("Pi=" + pi);
                Console.WriteLine("Obliczenia zakończone");
            }
        }
    }
}
