﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using System.Collections.Concurrent;

namespace RownolegleDane
{
    class Program
    {        
        static void Main_Cocnurrent(string[] args)
        {
            ConcurrentBag<int> cb = new ConcurrentBag<int>();
            List<int> l = new List<int>();

            ConcurrentStack<int> cs = new ConcurrentStack<int>();
            ConcurrentQueue<int> cq = new ConcurrentQueue<int>();

            Task[] zadania = new Task[10];
            
            int start = System.Environment.TickCount;
            for (int i = 0; i < zadania.Length; ++i)
            {
                //zadania[i] = Task.Factory.StartNew(
                zadania[i] = new Task(
                    (object j) =>
                    {
                        int _i = (int)j;
                        cb.Add(_i);                        
                    }
                    , i
                );
                zadania[i].Start();
            }
            Task.WaitAll(zadania);
            int stop = System.Environment.TickCount;
            Console.WriteLine("Liczba elementów w cb: " + cb.Count + " w czasie " + (stop-start).ToString());            

            start = System.Environment.TickCount;
            for (int i = 0; i < zadania.Length; ++i)
            {
                zadania[i] = new Task(
                    (object j) =>
                    {
                        int _i = (int)j;
                        lock(l) l.Add(_i);
                    }
                    , i
                );
                zadania[i].Start();
            }
            Task.WaitAll(zadania);
            stop = System.Environment.TickCount;
            Console.WriteLine("Liczba elementów w l: " + l.Count + " w czasie " + (stop - start).ToString());            

            start = System.Environment.TickCount;
            for (int i = 0; i < zadania.Length; ++i)
            {
                zadania[i] = new Task(
                    (object j) =>
                    {
                        int _i = (int)j;
                        lock (l) cs.Push(_i);
                    }
                    , i
                );
                zadania[i].Start();
            }
            Task.WaitAll(zadania);
            stop = System.Environment.TickCount;
            Console.WriteLine("Liczba elementów w CS: " + cs.Count + " w czasie " + (stop - start).ToString());

            start = System.Environment.TickCount;
            for (int i = 0; i < zadania.Length; ++i)
            {
                zadania[i] = new Task(
                    (object j) =>
                    {
                        int _i = (int)j;
                        lock (l) cq.Enqueue(_i);
                    }
                    , i
                );
                zadania[i].Start();
            }
            Task.WaitAll(zadania);
            stop = System.Environment.TickCount;
            Console.WriteLine("Liczba elementów w CQ: " + cq.Count + " w czasie " + (stop - start).ToString());

            for (int i = 0; i < zadania.Length; ++i)
            {
                Console.WriteLine("CB: " + cb.ElementAt(i) + ", L: " + l[i] + ", CS:" + cs.ElementAt(i) + ", CQ:" + cq.ElementAt(i));
            }
            
        }

        static void Main_BlockingCollection(string[] args)
        {
            const int rozmiar = 10;
            //BlockingCollection<int> kolekcja = new BlockingCollection<int>(rozmiar); //domyślnie ConcurrentQueue
            BlockingCollection<int> kolekcja = new BlockingCollection<int>(new ConcurrentStack<int>(), rozmiar);            

            Action producent =
                () =>
                {
                    for (int i = 0; i < rozmiar; i++)
                    {
                        kolekcja.Add(i);
                        Console.WriteLine("Dodano element {0}, liczba elementów {1}", i, kolekcja.Count);
                    }
                };
            Action konsument =
                () =>
                {
                    System.Threading.Thread.Sleep(500);
                    foreach (int i in kolekcja.GetConsumingEnumerable())
                    //foreach (int i in kolekcja)
                    {
                        Console.WriteLine("Pobrano element {0}, zostało elementów {1}", i, kolekcja.Count);
                    }
                };

            Task[] zadania = new Task[2];
            zadania[0] = Task.Run(producent);
            zadania[1] = Task.Run(konsument);
            Task.WaitAll(zadania);
        }

        //wlasna kolekcja wspolbiezna
        public class WspolbieznyStos<T> : IProducerConsumerCollection<T>
        {
            private object obiektSynchronizacji = new object();

            private Stack<T> stos = null;

            public WspolbieznyStos()
            {
                stos = new Stack<T>();
            }

            public WspolbieznyStos(IEnumerable<T> kolekcja)
            {
                stos = new Stack<T>(kolekcja);
            }

            public void Push(T element)
            {
                lock (obiektSynchronizacji) stos.Push(element);
            }

            public bool TryTake(out T element)
            {
                bool wynik = true;
                lock (obiektSynchronizacji)
                {
                    if (stos.Count == 0) { element = default(T); wynik = false; }
                    else element = stos.Pop();
                }
                return wynik;
            }

            /*public bool TryPop(out T element)
            {
                return TryTake(out element);
            }*/

            public bool TryAdd(T element)
            {
                try
                {
                    Push(element);
                    return true;
                }
                catch
                {
                    return false;
                }
            }

            public T[] ToArray()
            {
                lock (obiektSynchronizacji) return stos.ToArray();                
            }

            public void CopyTo(T[] tablica, int indeks)
            {
                lock (obiektSynchronizacji) stos.CopyTo(tablica, indeks);
            }

            public void CopyTo(Array tablica, int indeks)
            {
                CopyTo((T[])tablica, indeks); //??????
            }

            public IEnumerator<T> GetEnumerator()
            {
                lock (obiektSynchronizacji) return (stos as IEnumerable<T>).GetEnumerator();
                
                /*
                Stack<T> stos_kopia = null;
                lock (obiektSynchronizacji) stos_kopia = new Stack<T>(stos);
                return (stos_kopia as IEnumerable<T>).GetEnumerator();
                */
            }

            System.Collections.IEnumerator System.Collections.IEnumerable.GetEnumerator()
            {
                return (stos as System.Collections.IEnumerable).GetEnumerator();
            }

            public int Count
            {
                get { lock (obiektSynchronizacji) return stos.Count; }
            }

            public bool IsSynchronized
            {
                get { return true; }
            }

            public object SyncRoot
            {
                get { return obiektSynchronizacji; }
            }
        }

        static void Main(string[] args)
        {
            WspolbieznyStos<int> ws = new WspolbieznyStos<int>(new List<int>() {0,1,2,3,4,5,6,7,8,9});
            /*
            for (int i = 0; i < 10; ++i)
            {
                int element;
                if (ws.TryTake(out element)) Console.WriteLine("Próbowałem zdjąć element: " + element.ToString() + ", pozostało: " + ws.Count);
                else Console.WriteLine("Próba zdjęcia elementu nie powiodła się");
            }
            */

            List<Task> zadania = new List<Task>(ws.Count);
            foreach (int element in ws)
            {
                zadania.Add(Task.Run(
                    () =>
                    {
                        //Console.WriteLine("Element: " + element.ToString() + ", pozostało: " + ws.Count);
                        int _element;
                        ws.TryTake(out _element);
                        Console.WriteLine("Element: " + _element.ToString() + ", pozostało: " + ws.Count);
                    }
                ));                
            }
            Task.WaitAll(zadania.ToArray());
        }
    }
}
