﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Threading;

namespace ProducentKonsument
{
    class Konsument
    {
        public bool wlaczony = true;

        public void Konsumuj(Magazyn<int> magazyn)
        {
            magazyn.DodajDoMagazynu(1);
            Console.WriteLine("Konsumpcja");
        }
    }

    class Producent
    {

        public bool wlaczony = true;

        public void Produkuj(Magazyn<int> magazyn)
        {
            magazyn.Wydaj();
            Console.WriteLine("Produkcja");
        }
    }

    class Magazyn<T>
    {
        int pojemnosc = 10;

        private int Count
        {
            get
            {
                lock (stos)
                    return stos.Count;
            }
        }

        Stack<T> stos;
        private object obiektsynchronizacjidodawanie = new object();
        private object obiektsynchronizacjiodejmowanie = new object();

        public Magazyn(int pojemnosc)
        {
            stos = new Stack<T>(pojemnosc);
            this.pojemnosc = pojemnosc;
        }


        public T Wydaj()
        {
            //if (Count == 0)
            //{
            //    lock(obiektsynchronizacjiodejmowanie)
            //    {
            //        Console.WriteLine("Wątek konsumenta zatrzymany.");
            //        Monitor.Wait(obiektsynchronizacjiodejmowanie);
            //    }
            //}
            T dowydania;
            lock (obiektsynchronizacjidodawanie)
            {
                while (Count == 0)
                {
                    Thread.Sleep(10);
                }
                dowydania = stos.Pop();
            }
            Console.WriteLine("Stan magazynu po wydaniu: " + stos.Count);
            return dowydania;
        }

        public void DodajDoMagazynu(T element)
        {
            //if (Count >= pojemnosc)
            //{
            //    lock (obiektsynchronizacjidodawanie)
            //    {
            //        Console.WriteLine("Dodawanie wstrzymane");
            //        Monitor.Wait(obiektsynchronizacjidodawanie);
            //    }
                
            //}
            //lock (stos)
            //{
            //while (Count >= pojemnosc)
            //{
            //    Thread.Sleep(10);
            //}
            //lock (stos)
            //    stos.Push(element);
            //}
            lock (obiektsynchronizacjiodejmowanie)
            {
                while (Count >= pojemnosc)
                {
                    Thread.Sleep(10);
                }
                stos.Push(element);
            }
            Console.WriteLine("Stan magazynu po dodaniu: " + stos.Count);
            if (stos.Count > pojemnosc)
            {
                throw new Exception("Magazyn jest przepełniony!");
            }
        }
    }

    class Program
    {
        static void Main(string[] args)
        {
            const int ilosc_watkow = 10;
            Thread[] wKonsument = new Thread[ilosc_watkow];
            Thread[] wProducent = new Thread[ilosc_watkow];
            Random r = new Random();
            Magazyn<int> magazyn = new Magazyn<int>(10);
            for (int i = 0; i < ilosc_watkow; i++)
            {
                wKonsument[i] = new Thread(() =>
                {
                    Konsument konsument = new Konsument();
                    while (true)
                    {
                        while (konsument.wlaczony)
                        {
                            konsument.Konsumuj(magazyn);
                            Thread.Sleep(r.Next(500));
                        }
                    }
                });
                wKonsument[i].Start();
                wProducent[i] = new Thread(() =>
                {
                    Producent producent = new Producent();
                    while (true)
                    {
                        while (producent.wlaczony)
                        {
                            producent.Produkuj(magazyn);
                            Thread.Sleep(r.Next(500));
                        }
                    }
                });
                wProducent[i].Start();
            }
        }
    }
}
