﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Threading;

namespace ProducentKonsument
{
    class Konsument
    {
        public bool wlaczony = true;

        public void Konsumuj(Magazyn<int> magazyn)
        {
            magazyn.DodajDoMagazynu(1);
            Console.WriteLine("Konsumpcja");
        }
    }

    class Producent
    {

        public bool wlaczony = true;

        public void Produkuj(Magazyn<int> magazyn)
        {
            magazyn.Wydaj();
            Console.WriteLine("Produkcja");
        }
    }

    class Magazyn<T>
    {
        int pojemnosc = 10;

        Stack<T> stos;
        

        public Magazyn(int pojemnosc)
        {
            stos = new Stack<T>(pojemnosc);
            this.pojemnosc = pojemnosc;
        }


        public T Wydaj()
        {
            bool napisane = false;
            while (stos.Count == 0)
            {
                Thread.Sleep(10);
                if (!napisane)
                {
                    Console.WriteLine("Wątek konsumenta zatrzymany.");
                    napisane = true;
                }
            }
            T dowydania;
            lock (stos)
            {
                dowydania = stos.Pop();
                Console.WriteLine("Stan magazynu po wydaniu: " + stos.Count);
            }
            return dowydania;
        }

        public void DodajDoMagazynu(T element)
        {
            bool napisane = false;
            while (stos.Count >= pojemnosc)
            {
                Thread.Sleep(10);
                if (!napisane)
                {
                    Console.WriteLine("Wątek producenta zatrzymany.");
                    napisane = true;
                }
            }
            lock (stos)
            {
                stos.Push(element);
                Console.WriteLine("Stan magazynu po dodaniu: " + stos.Count);
            }
            if (stos.Count > pojemnosc)
            {
                throw new Exception("Magazyn jest przepełniony!");
            }
        }
    }

    class Program
    {
        static void Main(string[] args)
        {
            Thread wKonsument;
            Thread wProducent;
            Random r = new Random();
            Magazyn<int> magazyn = new Magazyn<int>(10);
            wKonsument = new Thread(() => {
                Konsument konsument = new Konsument();
                while (true)
                {
                    while (konsument.wlaczony)
                    {
                        konsument.Konsumuj(magazyn);
                        Thread.Sleep(r.Next(500));
                    }
                }
            });
            wKonsument.Start();
            wProducent = new Thread(() => {
                Producent producent = new Producent();
                while (true)
                {
                    while (producent.wlaczony)
                    {
                        producent.Produkuj(magazyn);
                        Thread.Sleep(r.Next(500));
                    }
                }
            });
            wProducent.Start();
        }
    }
}
