﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Threading;

namespace ProducentKonsument
{
    class Konsument
    {
        public bool wlaczony = true;

        public void Konsumuj(Magazyn magazyn, int ile)
        {
            magazyn.WydajZMagazynu(ile);
            Console.WriteLine("Konsumpcja");
        }
    }

    class Producent
    {

        public bool wlaczony = true;

        public void Produkuj(Magazyn magazyn, int ile)
        {
            magazyn.DodajDoMagazynu(ile);
            Console.WriteLine("Produkcja");
        }
    }

    class Magazyn
    {
        int licznik = 0;
        int pojemnosc = 10;

        public Magazyn(int poczatkowy)
        {
            licznik = poczatkowy;
        }


        private void ZmienStanMagazynu(int ile)
        {
            Interlocked.Add(ref licznik, ile);
        }

        public void WydajZMagazynu(int ile)
        {
            bool napisane = false;
            while (ile > licznik)
            {
                Thread.Sleep(10);
                if (!napisane)
                {
                    Console.WriteLine("Wątek konsumenta zatrzymany.");
                    napisane = true;
                }
            }

            ZmienStanMagazynu(-ile);
            Console.WriteLine("Stan magazynu po wydaniu: " + licznik);
            if (licznik < 0)
            {
                throw new Exception("Stan magazynu jest ujemny!");
            }
        }

        public void DodajDoMagazynu(int ile)
        {
            bool napisane = false;
            while (licznik+ile > pojemnosc)
            {
                Thread.Sleep(10);
                if (!napisane)
                {
                    Console.WriteLine("Wątek producenta zatrzymany.");
                    napisane = true;
                }
            }

            ZmienStanMagazynu(ile);
            Console.WriteLine("Stan magazynu po dodaniu: " + licznik);
            if (licznik > pojemnosc)
            {
                throw new Exception("Magazyn jest przepełniony!");
            }
        }
    }

    class Program
    {
        static void Main(string[] args)
        {
            Thread wKonsument;
            Thread wProducent;
            Random r = new Random();
            Magazyn magazyn = new Magazyn(5);
            wKonsument = new Thread(() => {
                Konsument konsument = new Konsument();
                while (true)
                {
                    while (konsument.wlaczony)
                    {
                        konsument.Konsumuj(magazyn, 1);
                        Thread.Sleep(r.Next(500));
                    }
                }
            });
            wKonsument.Start();
            wProducent = new Thread(() => {
                Producent producent = new Producent();
                while (true)
                {
                    while (producent.wlaczony)
                    {
                        producent.Produkuj(magazyn, 1);
                        Thread.Sleep(r.Next(500));
                    }
                }
            });
            wProducent.Start();
        }
    }
}
