﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using System.Threading;

namespace Bank
{
    class Program
    {
        class Konto
        {
            public long Id { get; private set; } //auto-implemented property
            decimal saldo;

            private void DrukujSaldo()
            {
                Console.WriteLine("Saldo konta " + Id + ": " + saldo);
            }

            public Konto(long id, decimal saldoPoczatkowe)
            {
                Id=id;
                saldo=saldoPoczatkowe;
                Console.WriteLine("Utworzone konto " + Id + " z saldem " + saldo);
                //DrukujSaldo();
            }

            public void Wplata(decimal kwota)
            {
                saldo += kwota;
                Console.WriteLine("Wpłata na konto " + Id + " kwoty " + kwota);
                DrukujSaldo();
            }

            public void Wyplata(decimal kwota)
            {
                saldo -= kwota;
                Console.WriteLine("Wypłata z konta " + Id + " kwoty " + kwota);
                DrukujSaldo();
            }
        }

        struct PoleceniePrzelewu //Command
        {
            public Konto nadawca;
            public Konto odbiorca;
            public decimal kwota;
        }

        //*
        //prowadzi do zakleszczenia
        static void ZrealizujPrzelew(object parametr)
        {
            if(parametr.GetType()!=typeof(PoleceniePrzelewu))
            {
                Console.WriteLine("Nierozpoznany błąd!");
                return;
            }
            PoleceniePrzelewu poleceniePrzelewu = (PoleceniePrzelewu)parametr; 

            //Console.WriteLine("Przelew - początek (" + Thread.CurrentThread.ManagedThreadId + ")");
            lock (poleceniePrzelewu.nadawca)
            {
                Console.WriteLine("Przelew - rezerwacja konta nadawcy");
                Thread.Sleep(1000);
                lock (poleceniePrzelewu.odbiorca)
                {
                    Console.WriteLine("Przelew - rezerwacja konta odbiorcy");
                    Thread.Sleep(1000);

                    //atomowe
                    //Console.WriteLine("Przelew - przed rozpoczeciem operacji");
                    poleceniePrzelewu.nadawca.Wyplata(poleceniePrzelewu.kwota);
                    poleceniePrzelewu.odbiorca.Wplata(poleceniePrzelewu.kwota);
                    //Console.WriteLine("Przelew - operacje zrealizowane");
                }
            }
            Console.WriteLine("Przelew - koniec (" + Thread.CurrentThread.ManagedThreadId + ")");
        }
        //*/

        /*
        static void ZrealizujPrzelew(object parametr)
        {
            if (parametr.GetType() != typeof(PoleceniePrzelewu))
            {
                Console.WriteLine("Nierozpoznany błąd!");
                return;
            }
            PoleceniePrzelewu poleceniePrzelewu = (PoleceniePrzelewu)parametr;

            Konto kontoPierwsze = (poleceniePrzelewu.nadawca.Id < poleceniePrzelewu.odbiorca.Id) ? poleceniePrzelewu.nadawca : poleceniePrzelewu.odbiorca;
            Konto kontoDrugie = (poleceniePrzelewu.nadawca.Id < poleceniePrzelewu.odbiorca.Id) ? poleceniePrzelewu.odbiorca : poleceniePrzelewu.nadawca;

            Console.WriteLine("Przelew - początek (" + Thread.CurrentThread.ManagedThreadId + ")");
            lock (kontoPierwsze)
            {
                Console.WriteLine("Przelew - rezerwacja konta nadawcy");
                Thread.Sleep(100);
                lock (kontoDrugie)
                {
                    Console.WriteLine("Przelew - rezerwacja konta odbiorcy");
                    Thread.Sleep(100);

                    //atomowe
                    Console.WriteLine("Przelew - przed rozpoczeciem operacji");
                    poleceniePrzelewu.nadawca.Wyplata(poleceniePrzelewu.kwota);
                    poleceniePrzelewu.odbiorca.Wplata(poleceniePrzelewu.kwota);
                    Console.WriteLine("Przelew - operacje zrealizowane");
                }
            }
            Console.WriteLine("Przelew - koniec (" + Thread.CurrentThread.ManagedThreadId + ")");
        }
        */

        static void Bank()
        {
            Konto konto1 = new Konto(1, 150);
            Konto konto2 = new Konto(2, 50);

            PoleceniePrzelewu p1 = new PoleceniePrzelewu() { kwota = 10, nadawca = konto1, odbiorca = konto2 };
            PoleceniePrzelewu p2 = new PoleceniePrzelewu() { kwota = 15, nadawca = konto1, odbiorca = konto2 };
            PoleceniePrzelewu p3 = new PoleceniePrzelewu() { kwota = 15, nadawca = konto2, odbiorca = konto1 };

            ThreadPool.QueueUserWorkItem(ZrealizujPrzelew,p1);
            ThreadPool.QueueUserWorkItem(ZrealizujPrzelew,p3);

            Console.WriteLine("Nie naciskaj klawisza Enter...");
            Console.ReadLine();
        }

        static void PieciuFilozofow()
        {
            int iloscFilozofow = 5;
            Konto[] konto = new Konto[iloscFilozofow];
            for(int i = 0; i < iloscFilozofow; i++) {
                konto[i] = new Konto(i, 100);
            }
            konto[0].Wplata(100);

            PoleceniePrzelewu[] przelew = new PoleceniePrzelewu[iloscFilozofow];
            for (int i = 0; i < iloscFilozofow; i++)
            {
                przelew[i] = new PoleceniePrzelewu() { kwota = 10, nadawca = konto[i], odbiorca = konto[(i + 1) < iloscFilozofow ? i + 1 : 0] };
            }

            for (int i = 0; i < iloscFilozofow; i++)
            {
                ThreadPool.QueueUserWorkItem(ZrealizujPrzelew, przelew[i]);
            }
            

            Console.WriteLine("Nie naciskaj klawisza Enter...");
            Console.ReadLine();
        }

        static void Main(string[] args)
        {
            //Bank();
            PieciuFilozofow();
        }
    }
}
