﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using Windows.Foundation;
using Windows.Foundation.Collections;
using Windows.UI.Xaml;
using Windows.UI.Xaml.Controls;
using Windows.UI.Xaml.Controls.Primitives;
using Windows.UI.Xaml.Data;
using Windows.UI.Xaml.Input;
using Windows.UI.Xaml.Media;
using Windows.UI.Xaml.Navigation;

// The Blank Page item template is documented at http://go.microsoft.com/fwlink/?LinkId=234238

using Windows.UI.Xaml.Shapes;
using Windows.UI;

namespace Rysowanie2D
{
    /// <summary>
    /// An empty page that can be used on its own or navigated to within a Frame.
    /// </summary>
    public sealed partial class MainPage : Page
    {
        public MainPage()
        {
            this.InitializeComponent();
        }

        /// <summary>
        /// Invoked when this page is about to be displayed in a Frame.
        /// </summary>
        /// <param name="e">Event data that describes how this page was reached.  The Parameter
        /// property is typically used to configure the page.</param>
        protected override void OnNavigatedTo(NavigationEventArgs e)
        {             
            kartka.Children.Add(CreateLine(new Point(10,10),new Point(100,100),new SolidColorBrush(Colors.Red), 10));
            kartka.Children.Add(CreateRectangle(new Point(150, 10), 200, 100, new SolidColorBrush(Colors.Black), new SolidColorBrush(Colors.Blue), 10));
            kartka.Children.Add(CreateEllipse(new Point(500, 60), 100, 50, new SolidColorBrush(Colors.Black), new SolidColorBrush(Colors.Blue), 10));
            kartka.Children.Add(CreatePolyline(new List<Point>() { new Point(650, 10), new Point(800, 35), new Point(650, 60), new Point(800, 100) }, new SolidColorBrush(Colors.Black), new SolidColorBrush(Colors.Blue), 10));
        }

        #region Shapes

        Line CreateLine(Point poczatek, Point koniec, SolidColorBrush kolor, double grubość)
        {
            Line l = new Line();
            l.X1 = poczatek.X;
            l.Y1 = poczatek.Y;
            l.X2 = koniec.X;
            l.Y2 = koniec.Y;
            l.Stroke = kolor;
            l.StrokeThickness = grubość;
            return l;
        }

        Rectangle CreateRectangle(Point pozycja, double szerokość, double wysokość, SolidColorBrush kolorObramowania, SolidColorBrush kolorWypelnienia, double grubośćObramowania)
        {
            Rectangle r = new Rectangle();
            r.Margin = new Thickness(pozycja.X,pozycja.Y,0,0);
            r.Width = szerokość;
            r.Height = wysokość;
            r.Fill = kolorWypelnienia;
            r.Stroke = kolorObramowania;
            r.StrokeThickness = grubośćObramowania;
            return r;
        }

        Ellipse CreateEllipse(Point środek, double promieńX, double promieńY, SolidColorBrush kolorObramowania, SolidColorBrush kolorWypelnienia, double grubośćObramowania)
        {
            Ellipse e = new Ellipse();
            e.Margin = new Thickness(środek.X - promieńX, środek.Y - promieńY, 0, 0);
            e.Width = 2 * promieńX;
            e.Height = 2 * promieńY;
            e.Fill = kolorWypelnienia;
            e.Stroke = kolorObramowania;
            e.StrokeThickness = grubośćObramowania;
            return e;
        }

        Polyline CreatePolyline(List<Point> punkty, SolidColorBrush kolor, SolidColorBrush kolorWypelnienia, double grubość)
        {
            Polyline pl = new Polyline();
            foreach (Point punkt in punkty)
                pl.Points.Add(punkt);
            pl.Stroke = kolor;
            pl.StrokeThickness = grubość;
            if (kolorWypelnienia != null) pl.Fill = kolorWypelnienia;
            return pl;
        }

        #endregion

    }
}
