﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using Color = Windows.UI.Color;

namespace Kolory
{
    static class Ustawienia
    {
        private static Windows.Storage.ApplicationDataContainer ustawienia = Windows.Storage.ApplicationData.Current.LocalSettings;

        public static bool CzyObecne()
        {
            return
                ustawienia.Values.Keys.Contains("kolor_R") &&
                ustawienia.Values.Keys.Contains("kolor_G") &&
                ustawienia.Values.Keys.Contains("kolor_B") &&
                ustawienia.Values.Keys.Contains("kolor_A");
        }

        public static Color Czytaj()
        {
            Color kolor;
            kolor.R = (byte)ustawienia.Values["kolor_R"];
            kolor.G = (byte)ustawienia.Values["kolor_G"];
            kolor.B = (byte)ustawienia.Values["kolor_B"];
            kolor.A = (byte)ustawienia.Values["kolor_A"];
            return kolor;
        }

        public static void Zapisz(Color kolor)
        {
            ustawienia.Values["kolor_R"] = kolor.R;
            ustawienia.Values["kolor_G"] = kolor.G;
            ustawienia.Values["kolor_B"] = kolor.B;
            ustawienia.Values["kolor_A"] = kolor.A;
        }

        public static void Usuń()
        {
            ustawienia.Values.Remove("kolor_R");
            ustawienia.Values.Remove("kolor_G");
            ustawienia.Values.Remove("kolor_B");
            ustawienia.Values.Remove("kolor_A");
        }
    }
}
