﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using Windows.Foundation;
using Windows.Foundation.Collections;
using Windows.UI.Xaml;
using Windows.UI.Xaml.Controls;
using Windows.UI.Xaml.Controls.Primitives;
using Windows.UI.Xaml.Data;
using Windows.UI.Xaml.Input;
using Windows.UI.Xaml.Media;
using Windows.UI.Xaml.Navigation;

using Color = Windows.UI.Color;

// The Blank Page item template is documented at http://go.microsoft.com/fwlink/?LinkId=234238

namespace Kolory
{
    /// <summary>
    /// An empty page that can be used on its own or navigated to within a Frame.
    /// </summary>
    public sealed partial class MainPage : Page
    {
        private bool zakonczonaInicjacja = false;

        public MainPage()
        {
            this.InitializeComponent();
            
            if (Ustawienia.CzyObecne())
                (Rectangle1.Fill as SolidColorBrush).Color = Ustawienia.Czytaj();

            Color kolor = (Rectangle1.Fill as SolidColorBrush).Color;
            SliderR.Value = kolor.R;
            SliderG.Value = kolor.G;
            SliderB.Value = kolor.B;
            SliderA.Value = kolor.A;
            UstalOpisTextBlock(kolor);

            Window.Current.VisibilityChanged += Current_VisibilityChanged;

            zakonczonaInicjacja = true;
        }

        void Current_VisibilityChanged(object sender, Windows.UI.Core.VisibilityChangedEventArgs e)
        {
            if (!e.Visible)
                Ustawienia.Zapisz((Rectangle1.Fill as SolidColorBrush).Color);
        }


        /// <summary>
        /// Invoked when this page is about to be displayed in a Frame.
        /// </summary>
        /// <param name="e">Event data that describes how this page was reached.  The Parameter
        /// property is typically used to configure the page.</param>
        protected override void OnNavigatedTo(NavigationEventArgs e)
        {
        }

        private void Button_Click_1(object sender, RoutedEventArgs e)
        {
            Ustawienia.Zapisz((Rectangle1.Fill as SolidColorBrush).Color);
            App.Current.Exit();
        }

        private static string SkładoweKoloruDec(Color kolor)
        {
            return "R=" + kolor.R.ToString() + ", G=" + kolor.G.ToString() + ", B=" + kolor.B.ToString() + ", A=" + kolor.A.ToString();
        }

        private void UstalOpisTextBlock(Color kolor)
        {
            TextBlock1.Text = SkładoweKoloruDec(kolor) + "\n";
            TextBlock1.Text += "HEX: " + SkładowoweKoloruHex(kolor);
        }

        private static string SkładowoweKoloruHex(Color kolor)
        {
            return "#" + kolor.R.ToString("X2") + kolor.G.ToString("X2") + kolor.B.ToString("X2");
        }

        private void SliderR_ValueChanged(object sender, RangeBaseValueChangedEventArgs e)
        {
            if (!zakonczonaInicjacja) return;

            Color kolor = new Color()
            {
                R = (byte)SliderR.Value,
                G = (byte)SliderG.Value,
                B = (byte)SliderB.Value,
                A = (byte)SliderA.Value
            };
            (Rectangle1.Fill as SolidColorBrush).Color = kolor;

            UstalOpisTextBlock(kolor);
        }

        
    }
}
