﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using Windows.Web.Syndication;

namespace CzytnikRSS
{
    public class FeedBasicData //opis blogu
    {
        public string Title { get; set; }
        public string Description { get; set; }
        public DateTime LastPost { get; set; }
        public string Url { get; set; }
    }

    public class FeedItem //opis wpisu w blogu
    {
        public string Title { get; set; }
        public string Author { get; set; }
        public string Content { get; set; }
        public DateTime PubDate { get; set; }
        public Uri link { get; set; }
    }

    public class Helper
    {
        public static List<string> GetFeedList()
        {
            List<string> feeds = new List<string>();
            feeds.Add("http://windowsteamblog.com/windows/b/developers/atom.aspx");
            feeds.Add("http://windowsteamblog.com/windows/b/windowsexperience/atom.aspx");
            feeds.Add("http://windowsteamblog.com/windows/b/extremewindows/atom.aspx");
            return feeds;
        }

        public static async Task<List<FeedBasicData>> GetFeedsBasicDataAsync()
        {
            List<FeedBasicData> feedsData = new List<FeedBasicData>();
            SyndicationClient client = new SyndicationClient();
            List<string> feeds = GetFeedList();

            foreach (var item in feeds)
            {
                try
                {
                    FeedBasicData basicData = new FeedBasicData();
                    SyndicationFeed feed = await client.RetrieveFeedAsync(new Uri(item));
                    basicData.Title = feed.Title.Text;
                    if (feed.Subtitle != null && feed.Subtitle.Text != null) basicData.Description = feed.Subtitle.Text;
                    basicData.LastPost = feed.Items[0].PublishedDate.DateTime;
                    basicData.Url = item;
                    feedsData.Add(basicData);
                }
                catch (Exception exc)
                {
                    return null;
                }
            }

            return feedsData;
        }
    }
}
