﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace SystemKont
{
    //enum Waluta { Zloty, Euro, Dolary, FrankiSzwajcarskie };

    static class Rozszerzenia
    {
        public static void ColorWriteLine(string komunikat, ConsoleColor kolor)
        {
            ConsoleColor biezacyKolor = Console.ForegroundColor;
            Console.ForegroundColor = kolor;
            Console.WriteLine(komunikat);
            Console.ForegroundColor = biezacyKolor;
        }
    }

    public class Konto
    {
        private ulong numerKonta;
        private string personalia;
        private decimal saldo;
        //private Waluta waluta;
        //możliwy debet;
        //rezerwacja środków + potwierdzenie i realizacja
        //indeksator na Konta
        //na zewnatrz tylko klasa Konta (zwracac numer a nie ref. do konta)
        //LINQ

        public Konto(ulong numerKonta, string personalia)
        {
            this.numerKonta = numerKonta;
            this.personalia = personalia;
            this.saldo = 0;
            Console.WriteLine("Utworzono konto nr " + this.numerKonta + " dla " + this.personalia);
        }

        public ulong NumerKonta
        {
            get
            {
                return numerKonta;
            }
        }

        public string Personalia
        {
            get
            {
                return personalia;
            }
        }

        public decimal Saldo
        {
            get
            {
                return saldo;
            }
        }

        public void Wpłata(decimal kwota)
        {
            if (kwota <= 0) throw new ArgumentException("Kwota wpłaty nie jest dodatnia");
            saldo += kwota;
            Console.WriteLine("Na konto " + numerKonta + " wpłacono " + kwota);
        }

        public void Wypłata(decimal kwota)
        {
            if (kwota <= 0) throw new ArgumentException("Kwota wpłaty nie jest dodatnia");
            if (kwota > saldo) throw new ArgumentException("Kwota przekracza dostępne środki");
            saldo -= kwota;
            Console.WriteLine("Z konta " + numerKonta + " wypłacono " + kwota);
        }
    }

    class Przelew
    {
        private Konto nadawca;
        private Konto odbiorca;
        private decimal kwota;

        public Przelew(Konto nadawca, Konto odbiorca, decimal kwota)
        {
            this.nadawca = nadawca;
            this.odbiorca = odbiorca;
            this.kwota = kwota;
        }

        public bool Realizuj()
        {
            try
            {
                nadawca.Wypłata(kwota);
            }
            catch (Exception exc)
            {
                Rozszerzenia.ColorWriteLine("Błąd: " + exc.Message, ConsoleColor.Red);
                return false;
            }

            //---------

            try
            {
                odbiorca.Wpłata(kwota);
            }
            catch (Exception exc)
            {
                Rozszerzenia.ColorWriteLine("Błąd: " + exc.Message, ConsoleColor.Red);
                try
                {
                    nadawca.Wpłata(kwota);
                }
                catch (Exception exc1)
                {
                    Rozszerzenia.ColorWriteLine("Błąd: " + exc1.Message + "\n" + "Bank in panic: wyparowała gotówka", ConsoleColor.Red);
                }
                return false;
            }

            Rozszerzenia.ColorWriteLine("Zrealizowany przelew z konta " + nadawca.NumerKonta + " na konto " + odbiorca.NumerKonta + " kwoty " + kwota, ConsoleColor.Green);
            return true;
        }
    }

    public class Konta
    {
        private List<Konto> konta = new List<Konto>();

        public void WydrukujInformacjeOKontach()
        {
            Console.WriteLine("Zestawienie kont:");
            foreach (Konto k in konta)
            {
                Console.WriteLine("Konto nr " + k.NumerKonta + ", właściciel: " + k.Personalia + ", saldo: " + k.Saldo);
            }
        }

        private ulong WyznaczNumerDlaNowegoKonta()
        {
            ulong najwiekszyNumerIstniejacegoKonta = 0;
            foreach (Konto k in konta)
            {
                if (k.NumerKonta > najwiekszyNumerIstniejacegoKonta) najwiekszyNumerIstniejacegoKonta = k.NumerKonta;
            }
            return najwiekszyNumerIstniejacegoKonta + 1;
        }

        public Konto ZalóżKonto(string personalia)
        {            
            ulong numerNowegoKonta = WyznaczNumerDlaNowegoKonta();
            Konto noweKonto = new Konto(numerNowegoKonta, personalia);
            konta.Add(noweKonto);
            return noweKonto;
        }        

        private Konto ZnajdzKonto(ulong numerKonta)
        {
            Konto konto = null;
            foreach (Konto k in konta)
            {
                if (numerKonta == k.NumerKonta)
                {
                    konto = k;
                    break;
                }
            }
            return konto;
        }

        public bool WykonajPrzelew(ulong numerKontaNadawcy, ulong numerKontaOdbiorcy, decimal kwota)
        {
            Konto nadawca = ZnajdzKonto(numerKontaNadawcy);
            if (nadawca == null)
            {
                Rozszerzenia.ColorWriteLine("Nie znaleziono konta nadawcy o podanym numerze", ConsoleColor.Red);
                return false;
            }
            else Rozszerzenia.ColorWriteLine("Znaleziono konto nadawcy należące do " + nadawca.Personalia, ConsoleColor.Green);

            Konto odbiorca = ZnajdzKonto(numerKontaOdbiorcy);
            if (odbiorca == null)
            {
                Rozszerzenia.ColorWriteLine("Nie znaleziono konta odbiorcy o podanym numerze", ConsoleColor.Red);
                return false;
            }
            else Rozszerzenia.ColorWriteLine("Znaleziono konto odbiorcy należące do " + odbiorca.Personalia, ConsoleColor.Green);

            Przelew przelew = new Przelew(nadawca, odbiorca, kwota);            
            return przelew.Realizuj();
        }        
    }
}
