﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

using System.Numerics;
using System.Threading.Tasks;

namespace ProgramowanieObiektowe
{
    public partial class Form2 : Form
    {
        Bitmap bufor;
        int szerokość, wysokość;

        Complex min = Complex.Zero;
        Complex max = Complex.Zero;

        private Complex PointToComplex(Point punkt)
        {
            return min + new Complex(
                punkt.X * (max.Real - min.Real) / szerokość,
                punkt.Y * (max.Imaginary - min.Imaginary) / wysokość);
        }

        bool ObliczZbiorMandelbrota(Complex min, Complex max, bool wymusObliczenia = false)
        {
            if(min!=this.min || max!=this.max)
            {
                this.Text = "Czekaj...";
                this.Cursor = Cursors.WaitCursor;

                this.min=min;
                this.max=max;

                Parallel.For(0, szerokość,
                    (int x) =>
                    {
                        for (int y = 0; y < wysokość; ++y)
                        {
                            Complex c = PointToComplex(new Point(x, y));

                            Complex z = Complex.Zero;
                            byte indeks = 0;
                            for (; indeks < 255; indeks++)
                            {
                                z = z * z + c;
                                if (z.Magnitude >= 2) break;
                            }
                            Color kolor = (indeks==255)?Color.Black:Color.FromArgb(255 - indeks, 255 - indeks, 255 - indeks, 255);
                            lock(bufor) bufor.SetPixel(x, y, kolor);                            
                        }
                    });

                this.Cursor = Cursors.Default;
                this.Text = "Zbiór Mandelbrota dla ("+min.Real+","+min.Imaginary+") - ("+max.Real+","+max.Imaginary+")";
                
                return true;
            }
            else return false;
        }
        
        public Form2()
        {
            InitializeComponent();
            szerokość = this.ClientSize.Width;
            wysokość = this.ClientSize.Height;
            bufor = new Bitmap(szerokość, wysokość);            
        }

        private void Form2_Paint(object sender, PaintEventArgs e)
        {
            lock(bufor) e.Graphics.DrawImage(bufor, 0, 0);
        }

        private void Form2_MouseClick(object sender, MouseEventArgs e)
        {
            double wspolczynnikZblizenia = (e.Button == MouseButtons.Left) ? 0.1 : 10;
            Complex srodek = PointToComplex(e.Location);            
            Complex zakres = this.max - this.min;
            Complex min = srodek - zakres * 0.5 * wspolczynnikZblizenia;
            Complex max = srodek + zakres * 0.5 * wspolczynnikZblizenia;
            ObliczZbiorMandelbrota(min, max);
            this.Refresh();            
        }

        private void Form2_MouseMove(object sender, MouseEventArgs e)
        {
            //Text = e.Location.ToString() + " " + PointToComplex(e.Location).ToString();
        }

        bool tylkoRaz = true;
        private void Form2_Shown(object sender, EventArgs e)
        {
            if (tylkoRaz)
            {
                tylkoRaz = false;
                ObliczZbiorMandelbrota(new Complex(-2.2, -1.2), new Complex(1.2, 1.2), true);
            }
        }
    }
}
