﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

using System.Numerics;

namespace ProgramowanieObiektowe
{
    public partial class Form2 : Form
    {
        Bitmap bufor;

        Complex min = Complex.Zero;
        Complex max = Complex.Zero;

        private Complex PointToComplex(Point punkt)
        {
            return min + new Complex(
                punkt.X * (max.Real - min.Real) / bufor.Width,
                punkt.Y * (max.Imaginary - min.Imaginary) / bufor.Height);
        }

        bool ObliczZbiorMandelbrota(Complex min, Complex max, bool wymusObliczenia = false)
        {
            if(min!=this.min || max!=this.max)
            {
                this.Text = "Czekaj...";
                this.Cursor = Cursors.WaitCursor;

                this.min=min;
                this.max=max;
                
                for(int x=0;x<bufor.Width;++x)
                    for (int y = 0; y < bufor.Height; ++y)
                    {
                        Complex c = PointToComplex(new Point(x, y));

                        Complex z = Complex.Zero;
                        byte indeks = 0;
                        for (; indeks < 255; indeks++)
                        {
                            z = z * z + c;
                            if (z.Magnitude >= 2) break;
                        }
                        if (indeks == 255) bufor.SetPixel(x, y, Color.Black);
                        else bufor.SetPixel(x, y, Color.FromArgb(255 - indeks, 255 - indeks, 255 - indeks, 255));                        
                    }

                this.Cursor = Cursors.Default;
                this.Text = "Zbiór Mandelbrota dla ("+min.Real+","+min.Imaginary+") - ("+max.Real+","+max.Imaginary+")";
                
                return true;
            }
            else return false;
        }
        
        public Form2()
        {
            InitializeComponent();
            bufor = new Bitmap(this.ClientSize.Width, this.ClientSize.Height);            
        }

        private void Form2_Paint(object sender, PaintEventArgs e)
        {
            e.Graphics.DrawImage(bufor, 0, 0);
        }

        private void Form2_MouseClick(object sender, MouseEventArgs e)
        {
            double wspolczynnikZblizenia = (e.Button == MouseButtons.Left) ? 0.1 : 10;
            Complex srodek = PointToComplex(e.Location);            
            Complex zakres = this.max - this.min;
            Complex min = srodek - zakres * 0.5 * wspolczynnikZblizenia;
            Complex max = srodek + zakres * 0.5 * wspolczynnikZblizenia;
            ObliczZbiorMandelbrota(min, max);
            this.Refresh();            
        }

        private void Form2_MouseMove(object sender, MouseEventArgs e)
        {
            //Text = e.Location.ToString() + " " + PointToComplex(e.Location).ToString();
        }

        bool tylkoRaz = true;
        private void Form2_Shown(object sender, EventArgs e)
        {
            if (tylkoRaz)
            {
                tylkoRaz = false;
                ObliczZbiorMandelbrota(new Complex(-2.2, -1.2), new Complex(1.2, 1.2), true);
            }
        }
    }
}
