﻿using System;
//using System.Collections.Generic;
//using System.Linq;
//using System.Text;

namespace AsystentSklepowy
{
    public class PrzekroczenieLimituException : Exception
    {
        public PrzekroczenieLimituException(string message)
            : base(message)
        {            
        }
    }

    public class AutoSumowanie
    {
        private decimal suma;
        private decimal limit;
        private static bool instancjaUtworzona = false;

        public AutoSumowanie(decimal limit, decimal kwotaPoczatkowa = 0)
        {
            if (instancjaUtworzona) throw new Exception("Nie można utworzyć więcej niż jednej instancji klasy AutoSumowanie");
            suma = kwotaPoczatkowa;
            this.limit = limit;
            ZasygnalizujJezeliLimitZostaniePrzekroczony(0);
            instancjaUtworzona = true;
        }

        private bool SprawdzCzyLimitZostaniePrzekroczony(decimal kwota)
        {
            return suma + kwota > limit;
        }

        private void ZasygnalizujJezeliLimitZostaniePrzekroczony(decimal kwota)
        {
            if (SprawdzCzyLimitZostaniePrzekroczony(kwota)) throw new PrzekroczenieLimituException("Limit został przekroczony");
        }

        public void Dodaj(decimal kwota)
        {
            if (kwota < 0) throw new ArgumentException("Kwota nie może być ujemna");
            ZasygnalizujJezeliLimitZostaniePrzekroczony(kwota);
            suma += kwota;            
        }

        public decimal Suma
        {
            get
            {
                return suma;
            }
        }

        public decimal Limit
        {
            get
            {
                return limit;
            }
        }

        //zdarzenie - zmiana sumy
    }
}
