﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace AsystentSklepowy
{
    public partial class Form1 : Form
    {
        AutoSumowanie autoSumowanie;

        private void WyswietlKomunikatOBledzie(string komunikat)
        {
            MessageBox.Show(komunikat, "Błąd", MessageBoxButtons.OK, MessageBoxIcon.Error);
        }

        public Form1()
        {
            InitializeComponent();

            decimal limit = 1000;
            Form2 form2 = new Form2();
            form2.Limit = limit;
            bool poprawnyLimit = false;
            do
            {
                DialogResult wynik = form2.ShowDialog();
                poprawnyLimit = (form2.Limit > 0) && (wynik == DialogResult.OK);
                if (!poprawnyLimit) WyswietlKomunikatOBledzie("Limit powinien być większy od zera i musi być zatwierdzony. Spróbuj jeszcze raz!");
            }
            while (!poprawnyLimit);

            autoSumowanie = new AutoSumowanie(form2.Limit);
            numericUpDown1.Maximum = autoSumowanie.Limit;
            progressBar1.Maximum = (int)autoSumowanie.Limit;
            button1_Click(null, null);
        }

        private void ustalKolor(Control kontrolka)
        {            
            if (autoSumowanie.Suma >= 0.8M * autoSumowanie.Limit) kontrolka.ForeColor = Color.Red;
            else
                if (autoSumowanie.Suma >= 0.6M * autoSumowanie.Limit) kontrolka.ForeColor = Color.Olive;
                else kontrolka.ForeColor = Color.Green;                
        }

        private void button1_Click(object sender, EventArgs e)
        {
            try
            {
                autoSumowanie.Dodaj(numericUpDown1.Value);
                label1.Text = autoSumowanie.Suma.ToString() + " zł / " + autoSumowanie.Limit.ToString() + " zł";
                progressBar1.Value = (int)autoSumowanie.Suma;
                ustalKolor(label1);
                //numericUpDown1.Maximum = autoSumowanie.Limit - autoSumowanie.Suma;
            }
            catch (PrzekroczenieLimituException)
            {
                WyswietlKomunikatOBledzie("Nastąpiło przekroczenie limitu");                
            }
            catch (ArgumentException)
            {
                WyswietlKomunikatOBledzie("Nieprawidłowa kwota");
            }
            catch (Exception)
            {
                WyswietlKomunikatOBledzie("Nierozpoznany błąd");                
            }
        }

        private void sprawdzKwote()
        {
            button1.Enabled = (autoSumowanie.Suma + numericUpDown1.Value < autoSumowanie.Limit);
        }

        private void numericUpDown1_ValueChanged(object sender, EventArgs e)
        {
            sprawdzKwote();
        }

        private void numericUpDown1_Scroll(object sender, ScrollEventArgs e)
        {
            sprawdzKwote();
        }

        private void numericUpDown1_KeyDown(object sender, KeyEventArgs e)
        {
            sprawdzKwote();            
        }

        private void numericUpDown1_MouseDown(object sender, MouseEventArgs e)
        {
            sprawdzKwote();
        }
    }
}
