﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace ProgramowanieObiektowe
{
    struct Complex
    {
        //pola
        private double re, im;

        //wlasnosci
        public double Real
        {
            get
            {
                return re;
            }
            set
            {
                re = value;
            }
        }

        public double Imag
        {
            get
            {
                return im;
            }
            set
            {
                im = value;
            }
        }

        public double Norm
        {
            get
            {
                return re * re + im * im;
            }
        }

        public double Abs
        {
            get
            {
                return Math.Sqrt(Norm);
            }
        }

        public double Arg
        {
            get
            {
                return Math.Atan2(Imag, Real);
            }
        }

        static public Complex Zero
        {
            get
            {
                return new Complex(0, 0);
            }
        }

        static public Complex One
        {
            get
            {
                return new Complex(1, 0);
            }
        }

        static public Complex I
        {
            get
            {
                return new Complex(0, 1);
            }
        }

        //konstruktor
        public Complex(double Real, double Imag=0)
        {
            re = Real;
            im = Imag;
        }

        //metody
        public override string ToString()
        {
            return "(" + Real.ToString() + "," + Imag.ToString() + ")";
        }

        public string ToString(string format)
        {            
            if (format == "c" || format == "C") return Real.ToString() + "+i" + Imag.ToString();
            return this.ToString();
        }

        /*
        public double Arg()
        {
            return Math.Atan2(Imag, Real);
        }
        */

        public Complex Conj()
        {
            //return new Complex() { Real = this.Real, Imag = -this.Imag };
            return new Complex(Real, -Imag);
        }

        static public Complex Polar(double Radius, double Theta)
        {
            return new Complex(Radius * Math.Cos(Theta), Radius * Math.Sin(Theta));
        }

        static public Complex operator +(Complex z)
        {
            return z;            
        }

        static public Complex operator -(Complex z)
        {
            return new Complex(-z.Real,-z.Imag);
        }

        static public Complex operator +(Complex z1, Complex z2)
        {
            return new Complex(z1.Real + z2.Real, z1.Imag + z2.Imag);
        }

        static public Complex operator -(Complex z1, Complex z2)
        {
            return new Complex(z1.Real - z2.Real, z1.Imag - z2.Imag);
            //return z1 + (-z2);
        }

        static public Complex operator *(Complex z1, Complex z2)
        {
            return new Complex(
                z1.Real * z2.Real - z1.Imag * z2.Imag,
                z1.Real * z2.Imag + z1.Imag * z2.Real);
        }

        static public explicit operator double(Complex z)
        {
            if(z.Imag!=0) throw new ArgumentException("Błąd rzutowania. Liczba zespolona posiada część urojoną ("+z.Imag+")");
            return z.Real;
        }

        static public implicit operator Complex(double re)
        {
            return new Complex(re);
        }
    }
}
