﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using System.Threading;

namespace Delegacje
{
    class Program
    {
        #region Wprawki w delegacjach
        delegate void TypMetody_PoZrobieniu(); //Action
        delegate void PrzykladowyDelegat2(double a, int b); //Action<double,b>

        static void RóbCoś(int ile,TypMetody_PoZrobieniu callback)
        {
            for (int i = 0; i < ile; ++i) Console.Write("*");
            callback();
        }

        static void PoZrobieniu()
        {
            Console.WriteLine("Skończyłem");
        }

        static Random r = new Random();
        static int LosowaLiczba()
        {
            int losowa = r.Next();
            Console.WriteLine("Losowa liczba: " + losowa.ToString());
            return losowa;
        }

        delegate int TypMetody_LosowaLiczba(); //Func<int>
        delegate double PrzykladowyDelegat(double a, int b); //Func<double,double,int>

        static void Main_Wprawki()
        {
            RóbCoś(1000, PoZrobieniu);

            TypMetody_PoZrobieniu metody = PoZrobieniu;
            metody += PoZrobieniu;
            metody();

            TypMetody_LosowaLiczba metody2 = LosowaLiczba;
            metody2 += LosowaLiczba;
            int wartoscZOstatniejMetody = metody2();
            Console.WriteLine("Wartość z ostatniej metody: " + wartoscZOstatniejMetody.ToString());
        }
        #endregion

        #region Calkowanie numeryczne
        delegate double Funkcja(double x); //Func<double,double>

        private static double całkuj(Funkcja f,double a,double b,uint n)
        {
            if(a>b) throw new ArgumentException("Niepoprawny przedział całkowania");
            double d=(b-a)/n;
            double wynik = 0;
            for (int i = 0; i < n; ++i)
            {
                //wynik += d * f(a + i * d); //poczatek przedzialu
                wynik += d * f(a + i * d + d / 2); //srodek przedzialu
                //Console.WriteLine((a + i * d).ToString());
            }
            return wynik;
        }

        static double funkcjaStała(double x)
        {
            return 1;
        }

        static double funkcjaLiniowa(double x)
        {
            return x;
        }

        static double funkcjaKwadratowa(double x)
        {
            return x * x;
        }

        static void Main_Calkowanie()
        {
            Console.WriteLine("Stała [0,2]: " + całkuj(funkcjaStała, 0, 2, 100));
            Console.WriteLine("Liniowa [-1,1]: " + całkuj(funkcjaLiniowa, -1, 1, 100)); //powinno byc zero, ale niesymetryczne
            Console.WriteLine("Liniowa [0,2]: " + całkuj(funkcjaLiniowa, 0, 2, 100));
            Console.WriteLine("Kwadratowa [0,1]: " + całkuj(funkcjaKwadratowa, 0, 1, 1000));
            Console.WriteLine("Sin [0,3.14]: " + całkuj(Math.Sin, 0, Math.PI, 1000));
            Console.WriteLine("Sin [0,6.28]: " + całkuj(Math.Sin, 0, 2 * Math.PI, 100));
        }
        #endregion

        #region Pochodne
        private static double pierwszaPochodna(Funkcja f, double x, double h)
        {
            return (f(x + h) - f(x - h)) / (2.0 * h);
        }

        private static double drugaPochodna(Funkcja f, double x, double h)
        {
            return (f(x + h) - 2.0 * f(x) + f(x - h)) / (h * h);
        }



        static void Main_Pochodne()
        {
            Funkcja f = funkcjaKwadratowa;
            double h = 0.01;
            Console.WriteLine("f: " + f.Method.Name);
            for (double x = -1; x <= 1; x += 0.1)
            {
                Console.WriteLine("x=" + x + "\tf(x)=" + f(x) + "\tf'(x)=" + pierwszaPochodna(f, x, h) + "\tf''(x)=" + drugaPochodna(f, x, h) + "\n");
            }
        }
        #endregion

        #region Watki
        /*
        static void WyswietlajPlusy()
        {
            Random r=new Random();
            while (true)
            {
                Console.Write("+");
                Thread.Sleep(r.Next(500));
            }
        }

        static void WyswietlajMinusy()
        {
            Random r = new Random();
            while (true)
            {
                Console.Write("-");
                Thread.Sleep(r.Next(2000));
            }
        }
        */

        static void WyswietlajZnak(object argument)
        {
            char znak = (char)argument;
            Random r = new Random();
            while (true)
            {
                Console.Write(znak);
                Thread.Sleep(r.Next(100));
            }
        }

        static void Main_Watki()
        {
            Thread tp = new Thread(WyswietlajZnak);
            Thread tm = new Thread(WyswietlajZnak);
            tp.Start('+');
            tm.Start('-');
        }
        #endregion

        static void Main(string[] args)
        {
            Main_Wprawki();
            Console.WriteLine();
            Main_Calkowanie();
            Console.WriteLine();
            Main_Pochodne();
            Console.WriteLine();
            Main_Watki();
        }
    }
}
