﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

using Kolory.Properties;

namespace Kolory
{
    public partial class Form1 : Form
    {
        Settings ustawienia = new Settings();

        public Form1()
        {
            InitializeComponent();

            trackBar1_ValueChanged(null,null);
        }

        private void trackBar1_ValueChanged(object sender, EventArgs e)
        {            
            panel1.BackColor = Color.FromArgb(
                trackBar1.Value,
                trackBar2.Value,
                trackBar3.Value);
            label1.Text = "#" + trackBar1.Value.ToString("X2") + trackBar2.Value.ToString("X2") + trackBar3.Value.ToString("X2");            
        }

        private void Form1_MouseEnter(object sender, EventArgs e)
        {
            //this.Opacity = 1;
        }

        private void Form1_MouseLeave(object sender, EventArgs e)
        {
            //this.Opacity = 0.5;
        }

        private void Form1_FormClosed(object sender, FormClosedEventArgs e)
        {
            ustawienia.R = trackBar1.Value;
            ustawienia.G = trackBar2.Value;
            ustawienia.B = trackBar3.Value;
            ustawienia.Save();

            for (; Opacity > 0; Opacity -= 0.005) 
                System.Threading.Thread.Sleep(1);
        }

        private void Form1_FormClosing(object sender, FormClosingEventArgs e)
        {
            DialogResult wynik = MessageBox.Show("Czy chcesz zamknąć aplikację?","Kolory",MessageBoxButtons.YesNo,MessageBoxIcon.Question,MessageBoxDefaultButton.Button2);
            switch (wynik)
            {
                case DialogResult.Yes:
                    break;
                case DialogResult.No:
                    e.Cancel = true;
                    break;
            }
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            trackBar1.Value = ustawienia.R;
            trackBar2.Value = ustawienia.G;
            trackBar3.Value = ustawienia.B;
        }
    }
}
