﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using System.Drawing; //Image, Bitmap; dodana referencja do System.Drawing.dll

namespace Varia
{
    class Program
    {
        private static Bitmap WczytajObraz(string nazwaPliku)
        {
            if (!System.IO.File.Exists(nazwaPliku))
            {
                ConsoleColor kolorOryginalny = Console.ForegroundColor;
                Console.ForegroundColor = ConsoleColor.Red;
                Console.WriteLine("Wskazany plik \"" + nazwaPliku + "\" nie istnieje.");
                Console.ForegroundColor = kolorOryginalny;
                return null;
            }
            Bitmap bmp = new Bitmap(Image.FromFile(nazwaPliku));
            Console.WriteLine("Obraz z pliku " + nazwaPliku + " o rozmiarach " + bmp.Width + "x" + bmp.Height);
            return bmp;
        }

        private static int ObliczJasnosc(Color kolor,double wspolczynnikSkalowania)
        {
            int jasnosc = (0 + kolor.R + kolor.G + kolor.B) / 3;
            return (int)(jasnosc * wspolczynnikSkalowania);
        }

        private static void zad2()
        {
            string skala = "*WMB8&%$#@oahkbdpqwmLCJUYXZO0Qrcvunxzjft/\\|()1{}[]-_+<>i!lI?.'`,^:\";~ ";
            int rozmiarSkali = skala.Length;
            double wspolczynnikSkalowania = (rozmiarSkali-1) / 255.0;

            //string nazwaPliku = @"obrazy\logo_umk.png";
            string nazwaPliku = @"obrazy\lady.gif";
            Bitmap bmp = WczytajObraz(nazwaPliku);
            if (bmp == null) return;
            for (int iy = 0; iy < bmp.Height; ++iy)
            {
                for (int ix = 0; ix < bmp.Width; ++ix) 
                {
                    int jasnosc = ObliczJasnosc(bmp.GetPixel(ix, iy), wspolczynnikSkalowania);
                    Console.Write(skala[jasnosc]);
                }
                Console.WriteLine();
            }
        }

        static void Main(string[] args)
        {
            zad2();
        }
    }
}
