﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Varia
{
    class Program
    {
        #region Silnia
        private static ulong Silnia(uint argument)
        {
            if (argument > 20) throw new ArgumentException("Wartość dla tego argumentu przekracza zakres typu long");
            ulong wynik = 1;
            for (uint i = 2; i <= argument; i++)
                wynik *= i;
            return wynik;
        }

        private static uint Silnia(byte argument)
        {
            if (argument > 13) throw new ArgumentException("Wartość dla tego argumentu przekracza zakres typu int");
            uint wynik = 1;
            for (uint i = 2; i <= argument; i++)
                wynik *= i;
            return wynik;
        }

        private static uint SilniaRekurencja(byte argument)
        {
            if (argument > 13) throw new ArgumentException("Wartość dla tego argumentu przekracza zakres typu int");
            if (argument == 1 || argument == 0) return 1;
            else return argument * Silnia(--argument);
        }

        private static uint Silnia_DoWhile(byte argument)
        {
            if (argument > 13) throw new ArgumentException("Wartość dla tego argumentu przekracza zakres typu int");
            uint wynik = 1;
            do
            {
                wynik *= argument--;
            }
            while (argument > 1);            
            return wynik;
        }

        private static uint[] ciagFibonnaciego(uint iloscElementow)
        {
            uint[] tablica = new uint[iloscElementow];
            if (iloscElementow > 0) tablica[0] = 0;
            if (iloscElementow > 1) tablica[1] = 1;
            if (iloscElementow > 2)
            {
                for (int i = 2; i < iloscElementow; ++i)
                {
                    tablica[i] = tablica[i - 1] + tablica[i - 2];
                }
            }
            return tablica;
        }
        #endregion

        #region NWD
        private static uint NWD(uint a, uint b)
        {
            //NWD
            uint mniejsza = (a < b) ? a : b;
            for (uint i = mniejsza; i > 0; i--)
                if ((a % i == 0) && (b % i == 0))
                {
                    return i;
                }
            return 1;
        }
        #endregion

        private static void PodwojnaPetla()
        {
            for(int x=0;x<3;++x)
            {
                for (int y = 0; y < 3; ++y)
                {
                    //if (x == 1 && y == 1) continue;
                    //if (x == 1 && y == 1) break;
                    if (x == 1 && y == 1) goto koniec;
                    Console.Write("(" + x + "," + y + ") ");
                }
                Console.WriteLine();
            }
        koniec:
            Console.WriteLine("Koniec");
        }

        static void Main(string[] args)
        {
            PodwojnaPetla();            

            Console.WriteLine("\nSilnia(int)");
            for (uint i = 0; i <= 20; i++)
                Console.WriteLine(i+"!="+Silnia(i));

            Console.WriteLine("\nSilnia(byte)");
            for (byte i = 0; i <= 13; i++)
                Console.WriteLine(i + "!=" + Silnia(i));

            Console.WriteLine("\nSilniaRekurencja(byte)");
            for (byte i = 0; i <= 13; i++)                
                Console.WriteLine(i + "!=" + SilniaRekurencja(i));

            Console.WriteLine("\nSilnia_DoWhile(byte)");
            for (byte i = 0; i <= 13; i++)
                Console.WriteLine(i + "!=" + Silnia_DoWhile(i));

            Console.WriteLine("\nNWD(12,8)=" + NWD(12, 8).ToString());
            Console.WriteLine("NWD(8,12)=" + NWD(8, 12).ToString());
            Console.WriteLine("NWD(20,25)=" + NWD(20, 25).ToString());

            Console.WriteLine("Ciąg Fibonnaciego: ");
            uint[] cf = ciagFibonnaciego(100);
            foreach (uint element in cf) Console.Write(element.ToString() + "; ");
            Console.WriteLine();
        }
    }
}
