﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using System.Threading;

namespace MonteCarloPi
{
    class Program
    {
        static Random r = new Random();
        static int ileWątków = 10;//Environment.ProcessorCount;
        static double pi = 0;

        static EventWaitHandle[] ewht = new EventWaitHandle[ileWątków];

        static void Main(string[] args)
        {
            bool pierwszaInstancja;
            Mutex m = new Mutex(true, "Bardzo wyjątkowy łańcuch identyfikujący mutex", out pierwszaInstancja);
            if (pierwszaInstancja)
            {
                Console.WriteLine("Pierwsza instancja");
            }
            else
            {
                Console.WriteLine("Kolejna instancja");
                return;
            }

            int tickCountStart = Environment.TickCount;            
            Console.WriteLine("Liczba procesorów: " + ileWątków.ToString());

            ThreadPool.SetMaxThreads(30, 100);
            WaitCallback metodaWatku = new WaitCallback(uruchomObliczeniaPi);
            for (int i = 0; i < ileWątków; ++i)
            {
                ewht[i] = new EventWaitHandle(false, EventResetMode.AutoReset);
                ThreadPool.QueueUserWorkItem(metodaWatku, i);
            }

            for (int i = 0; i < ileWątków; ++i) ewht[i].WaitOne();

            pi /= ileWątków;
            Console.WriteLine("Ostatecznie, Pi={0}, blad={1}", pi, Math.PI - pi);

            int tickCountStop = Environment.TickCount;
            int tickCountDuration = tickCountStop - tickCountStart;
            Console.WriteLine(tickCountDuration.ToString());
        }

        static double obliczPi(long liczbaProb)
        {
            Random r = new Random(Program.r.Next());
            double x, y;
            double liczbaPunktowWKole = 0;
            
            for (long i = 0; i < liczbaProb; ++i)
            {
                x = r.NextDouble();
                y = r.NextDouble();
                //if(i%10000==0) Console.WriteLine("x=" + x.ToString() + ", y=" + y.ToString());
                /*
                if (i == liczbaProb / 2)
                {                    
                    lock(Program.r)
                    {
                        Console.WriteLine("Synchronizacja-początek: " + Thread.CurrentThread.ManagedThreadId.ToString());
                        Thread.Sleep(1000);
                        Console.WriteLine("Synchronizacja-koniec: " + Thread.CurrentThread.ManagedThreadId.ToString());
                    }
                }
                */
                if (x * x + y * y < 1) liczbaPunktowWKole++;
            }
            return 4 * liczbaPunktowWKole / liczbaProb;
        }

        static void uruchomObliczeniaPi(object parametr)
        {
            int i = -1;
            if (parametr is int) i = (int)parametr;
            else
            {
                Console.WriteLine("Wątek nr {0} - błędny parametr", Thread.CurrentThread.ManagedThreadId);
                return;
            }


            Console.WriteLine("Parametr i=" + i.ToString());

            try
            {
                double pi = obliczPi((i+1)*1000000000/ileWątków);
                Program.pi += pi;
                Console.WriteLine("Pi={0}, blad={1}", pi, Math.PI - pi);
                Console.WriteLine("Wątek nr {0}", Thread.CurrentThread.ManagedThreadId);
                ewht[i].Set();
            }
            catch (ThreadAbortException exc)
            {
                Console.WriteLine("Obliczenia zostały przerwane wywołaniem metody Abort");
                Console.WriteLine(exc.Message);
            }
            catch (Exception exc)
            {
                Console.WriteLine(exc.Message);
            }
        }
    }
}
