﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using System.Threading;

namespace MonteCarloPi
{
    class Program
    {
        static Random r = new Random();

        static void Main(string[] args)
        {
            //uruchomObliczeniaPi();

            ThreadStart ts = new ThreadStart(uruchomObliczeniaPi);
            Thread t = new Thread(ts);
            //t.IsBackground = true;
            t.Priority = ThreadPriority.Lowest;
            t.Start();
            Console.WriteLine("Po uruchomieniu obliczeń");
            /*
            Thread.Sleep(1000);
            //Thread.SpinWait(10000);
            Console.WriteLine("Po uruchomieniu obliczeń + 1s");
            //t.Abort();
            Console.WriteLine("Wstrzymuję wątek");
            t.Suspend();
            Console.WriteLine("Po wstrzymaniu wątka");
            Thread.Sleep(10000);
            Console.WriteLine("Wznawiam wątek");
            t.Resume();
            Console.WriteLine("Wznowiony wątek");
            t.Join();
            Console.WriteLine("Obliczenia zostały zakończone");
            Console.WriteLine("Wątek główny nr {0}", Thread.CurrentThread.ManagedThreadId);
            */
        }

        static double obliczPi(long liczbaProb)
        {
            double x, y;
            double liczbaPunktowWKole = 0;
            
            for (long i = 0; i < liczbaProb; ++i)
            {
                x = r.NextDouble();
                y = r.NextDouble();
                if (x * x + y * y < 1) liczbaPunktowWKole++;
            }
            return 4 * liczbaPunktowWKole / liczbaProb;
        }

        static void uruchomObliczeniaPi()
        {
            try
            {
                double pi = obliczPi(100000000);
                Console.WriteLine("Pi={0}, blad={1}", pi, Math.PI - pi);
                Console.WriteLine("Wątek nr {0}", Thread.CurrentThread.ManagedThreadId);
            }
            catch (ThreadAbortException exc)
            {
                Console.WriteLine("Obliczenia zostały przerwane wywołaniem metody Abort");
                Console.WriteLine(exc.Message);
            }
            catch (Exception exc)
            {
                Console.WriteLine(exc.Message);
            }
        }
    }
}
