﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace LinqToObjects
{
    public partial class Form1 : Form
    {
        List<Osoba> lista = new List<Osoba>();        

        public Form1()
        {
            InitializeComponent();

            lista.Add(new Osoba() { Id = 0, Imię = "Jacek", Nazwisko = "Matulewski", NumerTelefonu = "1234567890", Wiek = 40 });
            lista.Add(new Osoba() { Id = 1, Imię = "Jakub", Nazwisko = "Korociński", NumerTelefonu = "911", Wiek = 22 });
            lista.Add(new Osoba() { Id = 2, Imię = "Joanna", Nazwisko = "Stołpiec", NumerTelefonu = "97737346782", Wiek = 18 });
            lista.Add(new Osoba() { Id = 3, Imię = "Oliwia", Nazwisko = "Potwardowska", NumerTelefonu = "39242384", Wiek = 22 });
            lista.Add(new Osoba() { Id = 4, Imię = "Piotr", Nazwisko = "Ablewski", NumerTelefonu = "2424234", Wiek = 43 });
            lista.Add(new Osoba() { Id = 5, Imię = "Andrzej", Nazwisko = "Bejgier", NumerTelefonu = "1234567890", Wiek = 26 });
            lista.Add(new Osoba() { Id = 6, Imię = "Rafał", Nazwisko = "Burzyński", NumerTelefonu = "911", Wiek = 22 });
            lista.Add(new Osoba() { Id = 7, Imię = "Przemysław", Nazwisko = "Drzymała", NumerTelefonu = "97737346782", Wiek = 18 });
            lista.Add(new Osoba() { Id = 8, Imię = "Mateusz", Nazwisko = "Dudek", NumerTelefonu = "39242384", Wiek = 22 });
            lista.Add(new Osoba() { Id = 9, Imię = "Łukasz", Nazwisko = "Kiełczykowski", NumerTelefonu = "2424234", Wiek = 22 });
            lista.Add(new Osoba() { Id = 10, Imię = "Mateusz", Nazwisko = "Lamparski", NumerTelefonu = "2424234", Wiek = 22 });
            lista.Add(new Osoba() { Id = 11, Imię = "Marcin", Nazwisko = "Przybył", NumerTelefonu = "2424234", Wiek = 32 });
            lista.Add(new Osoba() { Id = 12, Imię = "Michał", Nazwisko = "Skórcz", NumerTelefonu = "2424234", Wiek = 22 });
            lista.Add(new Osoba() { Id = 13, Imię = "Małgorzata", Nazwisko = "Stankiewicz", NumerTelefonu = "2424234", Wiek = 22 });

            Wyswietl(lista, true, "Pełna lista");
        }

        public void Wyswietl(IEnumerable<String> osoby, bool czyCzyscic = true, string naglowek = "")
        {
            if (czyCzyscic) listBox1.Items.Clear();
            else listBox1.Items.Add("---------------------");
            if (naglowek != "") listBox1.Items.Add(naglowek + ":");
            listBox1.Items.AddRange(osoby.ToArray());
            listBox1.Items.Add("\tIlość elementów: " + osoby.Count().ToString());
        }

        public void Wyswietl(IEnumerable<Osoba> osoby, bool czyCzyscic = true, string naglowek = "")
        {
            /*
            List<string> ls = new List<string>(lista.Count);
            foreach (Osoba o in osoby)
            {
                ls.Add(o.ToString());
            }
            listBox1.Items.Clear();
            listBox1.Items.AddRange(ls.ToArray());
            */
            string[] ts = new string[osoby.Count()];
            for (int i = 0; i < osoby.Count(); ++i)
            {
                ts[i] = osoby.ElementAt(i).ToString();
            }
            Wyswietl(ts, czyCzyscic, naglowek);
        }

        private void button1_Click(object sender, EventArgs e)
        {
            var wynikZapytania = (
                from Osoba o in lista
                where o.Imię.EndsWith("a")
                orderby o.Wiek
                select o
                //select new Osoba(o)
                //select o.Imię+" "+o.Nazwisko
                //select new {Imię = o.Imię, Nazwisko = o.Nazwisko}
                    ).ToList<Osoba>();
            MessageBox.Show(wynikZapytania.GetType().FullName);
            Wyswietl(wynikZapytania, false, "Wynik zapytania");

            wynikZapytania[0].Wiek = 50;

            Wyswietl(wynikZapytania, false, "Wynik zapytania po zmianach");
            Wyswietl(lista, false, "Pełna lista po zmianach");
        }

        private void button2_Click(object sender, EventArgs e)
        {
            Wyswietl(lista, true, "Pełna lista");
            listBox1.Items.Add("---------------------");
            listBox1.Items.Add("Analiza:");
            listBox1.Items.Add("Minimalny wiek: " + lista.Min(o => o.Wiek).ToString());
            listBox1.Items.Add("Maksymalny wiek: " + lista.Max(o => o.Wiek).ToString());
            listBox1.Items.Add("Suma lat: " + lista.Sum(o => o.Wiek).ToString());
            listBox1.Items.Add("Średni wiek: " + lista.Average(o => o.Wiek).ToString());

            listBox1.Items.Add("Pierwszy, którego wiek >30: " + lista.First(o => o.Wiek > 30).ToString());
        }

        private void button3_Click(object sender, EventArgs e)
        {
            var wynikZapytania = from Osoba o in lista
                                 group o by o.Wiek into g
                                 select g;

            MessageBox.Show(wynikZapytania.GetType().FullName);

            List<string> s = new List<string>();
            foreach (var g in wynikZapytania)
            {
                s.Add("Grupa osób o wieku " + g.Key);
                foreach (Osoba o in g)
                {
                    s.Add(o.ToString());
                }
                s.Add("");
            }
            Wyswietl(s,true,"Pełna lista w grupach");
        }

        private void button4_Click(object sender, EventArgs e)
        {
            var listaKobiet =
                from Osoba o in lista
                where o.Imię.EndsWith("a")
                select o;
            var listaOsobMlodych =
                from Osoba o in lista
                where o.Wiek <= 30
                select o;

            Wyswietl(listaKobiet, true, "Lista kobiet");
            Wyswietl(listaOsobMlodych, false, "Lista osób 30-");

            //var listaPolaczona = listaKobiet.Concat(listaOsobMlodych).Distinct();
            var listaPolaczona = listaKobiet.Union(listaOsobMlodych);
            Wyswietl(listaPolaczona, false, "Połączona lista bez powtórzeń");
        }

        private void button5_Click(object sender, EventArgs e)
        {
            var lista1 =
                from Osoba o in lista
                where o.Imię.EndsWith("a")
                select new { Id = o.Id, Imię = o.Imię, Nazwisko = o.Nazwisko };
            var lista2 =
                from Osoba o in lista
                where o.Wiek <= 30
                select new { Id = o.Id, Wiek = o.Wiek, NumerTelefonu = o.NumerTelefonu };

            var listaPolaczona = from p in lista1
                                 join l in lista2
                                 on p.Id equals l.Id
                                 select new Osoba(p.Id, p.Imię, p.Nazwisko, l.Wiek, l.NumerTelefonu);

            Wyswietl(listaPolaczona, true, "Join");
        }

        private void button6_Click(object sender, EventArgs e)
        {
            Dictionary<string,string> slownik = new Dictionary<string,string>(10);
            slownik.Add("słownik", "dictionary");
            slownik.Add("zmęczony", "tired");
            slownik.Add("wykończony", "excosted");
            slownik.Add("nieszczęśliwy", "unhappy");
            slownik.Add("jest", "is");
            slownik.Add("nie", "not");
            slownik.Add("i", "and");
            slownik.Add("już", "already");

            string pl = "Jacek już nie jest zmęczony i nieszczęśliwy.";
            string[] slowa = pl.Split(' ','.');
            string en = "";
            for (int i = 0; i < slowa.Length; ++i)
            {
                if (slownik.Keys.Contains(slowa[i])) en += slownik[slowa[i]];
                else en += slowa[i];
                en += " ";
            }
            MessageBox.Show(pl+"\n"+en);
        }

        private void zmienWartosc(double d1, ref double d2, out double d3)
        {            
            d1 = 1;
            d2 = 1;
            d3 = 1;
            listBox1.Items.Add("d1=" + d1.ToString() + ", d2=" + d2.ToString() + ", d3=" + d3.ToString());
        }

        private int suma(params int[] skladniki)
        {
            int wynik = 0;
            for (int i = 0; i < skladniki.Length; ++i)
                wynik += skladniki[i];
            return wynik;
        }

        private void button7_Click(object sender, EventArgs e)
        {
            listBox1.Items.Clear();

            double d1 = 0;
            double d2 = 0;
            double d3 = 0;
            listBox1.Items.Add("d1=" + d1.ToString() + ", d2=" + d2.ToString() + ", d3=" + d3.ToString());
            zmienWartosc(d1, ref d2, out d3);
            listBox1.Items.Add("d1=" + d1.ToString() + ", d2=" + d2.ToString() + ", d3=" + d3.ToString());

            int[] tablica = { 1, 2, 3, 4, 5, 6, 7 };
            listBox1.Items.Add(suma(tablica).ToString());
            listBox1.Items.Add(suma(new int[] { 1, 2, 3, 4, 5, 6, 7 }).ToString());
            listBox1.Items.Add(suma(1, 2, 3, 4, 5, 6, 7).ToString());
        }
    }

    //klasa encji
    public class Osoba
    {
        public Osoba()
            :this(0, "", "", 0, "")
        {            
        }

        public Osoba(Osoba pierwowzór)
            :this(pierwowzór.Id,pierwowzór.Imię,pierwowzór.Nazwisko,pierwowzór.Wiek,pierwowzór.NumerTelefonu)
        {
        }

        public Osoba Clone()
        {
            return new Osoba(this);
        }

        public Osoba(int Id, string Imię, string Nazwisko, int Wiek, string NumerTelefonu)
        {
            this.Id = Id;
            this.Imię=Imię;
            this.Nazwisko = Nazwisko;
            this.Wiek = Wiek;
            this.NumerTelefonu = NumerTelefonu;
        }

        public int Id;
        public string Imię;
        public string Nazwisko;
        public int Wiek;
        public string NumerTelefonu;

        public override string ToString()
        {
            return Imię + " " + Nazwisko + " (" + Id.ToString() + "), wiek: " + Wiek;
        }
    }
}
