﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace RysowanieNaFormie
{
    public partial class Form1 : Form
    {
        Random r = new Random();
        Color kolorGora = Color.Green;
        Color kolorDol = Color.Blue;

        public Form1()
        {
            InitializeComponent();

            kolorGora = Color.FromArgb(r.Next(255), r.Next(255), r.Next(255));
            kolorDol = Color.FromArgb(r.Next(255), r.Next(255), r.Next(255));
        }
        
        private void Form1_Paint(object sender, PaintEventArgs e)
        {
            Graphics gr = e.Graphics;
            gr.DrawString("Tu jestem!", this.Font, Brushes.Navy, 10, 10);

            for (int i = 0; i < this.ClientRectangle.Height; ++i)
            {                
                gr.DrawLine(new Pen(kolorGora.LerpWith(kolorDol, i / (double)this.ClientRectangle.Height)), 0, i, this.ClientRectangle.Width, i);
            }
        }

        private void button1_Click(object sender, EventArgs e)
        {
            colorDialog1.Color = (sender == button1) ? kolorGora : kolorDol ;
            if (colorDialog1.ShowDialog() == DialogResult.OK)
            {
                if (sender == button1) kolorGora = colorDialog1.Color;
                else kolorDol = colorDialog1.Color;
                this.Refresh();
            }
        }

        
    }

    static class Rozszerzenie
    {
        public static int Lerp(int poczatek, int koniec, double wspolczynnik)
        {
            return (int)(poczatek + (koniec - poczatek) * wspolczynnik);
        }

        public static Color Lerp(Color poczatek, Color koniec, double wspolczynnik)
        {
            int r = Lerp(poczatek.R, koniec.R, wspolczynnik);
            int g = Lerp(poczatek.G, koniec.G, wspolczynnik);
            int b = Lerp(poczatek.B, koniec.B, wspolczynnik);
            return Color.FromArgb(r, g, b);    
        }

        public static Color LerpWith(this Color kolor,Color other,double wspolczynnik)
        {
            return Lerp(kolor,other,wspolczynnik);
        }

        public static void Show(this object o)
        {
            MessageBox.Show(o.ToString());
        }
    };
}
