﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;

using System.Xml.Linq;

namespace KsiegaGosci
{
    //Struktura opisująca elementarny typ danych (klasa encji)
    public struct Wpis
    {
        private string nazwaUżytkownika;
        private string treść;
        private DateTime data;
        private string adresIP;

        public string NazwaUżytkownika { get { return nazwaUżytkownika; } }
        public string Treść { get { return treść; } }
        public DateTime Data { get { return data; } }
        public string AdresIP { get { return adresIP; } }

        public Wpis(string nazwaUżytkownika, string treść, DateTime data, string adresIP)
        {
            this.nazwaUżytkownika = nazwaUżytkownika;
            this.treść = treść; ;
            this.data = data;
            this.adresIP = adresIP;
        }
    }

    //Model księgi gości. Tu zapisana jest logika biznesowa aplikacji
    public class Wpisy
    {
        List<Wpis> wpisy = new List<Wpis>();

        public bool ZapiszDoPlikuPoKażdymDodaniuWpisu = true;

        public void Dodaj(Wpis wpis)
        {
            wpisy.Add(wpis);
            if (ZapiszDoPlikuPoKażdymDodaniuWpisu) ZapiszDoPlikuXml();
        }
        
        public int Ilość
        {
            get
            {
                return wpisy.Count;
            }
        }

        public Wpis this[int i]
        {
            get
            {
                return wpisy[i];
            }
        }        

        public bool ZapiszDoPlikuXml(string nazwaPlikuXml = null)
        {
            if (nazwaPlikuXml == null) nazwaPlikuXml = this.nazwaPlikuXml;

            try
            {
                if (System.IO.File.Exists(nazwaPlikuXml)) System.IO.File.Copy(nazwaPlikuXml, nazwaPlikuXml + ".bak", true);

                XDocument xml = new XDocument(
                    new XDeclaration("1.0", "utf-8", "yes"),
                    new XElement("Wpisy",
                        new XElement("DataZapisu", DateTime.Now.ToString()),
                        from wpis in wpisy
                        select new XElement("Wpis",
                            new XElement("NazwaUżytkownika", wpis.NazwaUżytkownika),
                            new XElement("Treść", wpis.Treść),
                            new XElement("Data", wpis.Data),
                            new XElement("AdresIP", wpis.AdresIP)
                        )
                    )
                );

                xml.Save(nazwaPlikuXml);
                //Global.DopiszDoPlikuLog("Zapis prawidłowy");
                return true;
            }
            catch(Exception exc)
            {
                Global.DopiszDoPlikuLog(exc.Message);
                return false;
            }
        }

        private bool CzytajZPlikuXml(string nazwaPlikuXml)
        {
            try
            {
                XDocument xml = XDocument.Load(nazwaPlikuXml);

                IEnumerable<Wpis> odczytaneWpisy =
                    from wpis in xml.Descendants("Wpis")
                    select
                       new Wpis(
                           wpis.Element("NazwaUżytkownika").Value,
                           wpis.Element("Treść").Value,
                           DateTime.Parse(wpis.Element("Data").Value),
                           wpis.Element("AdresIP").Value);

                wpisy.Clear();
                wpisy.AddRange(odczytaneWpisy);

                return true;
            }
            catch
            {
                return false;
            }
        }

        string nazwaPlikuXml;

        public Wpisy(string nazwaPlikuXml)
        {
            this.nazwaPlikuXml = nazwaPlikuXml;
            CzytajZPlikuXml(nazwaPlikuXml);
        }
    }
}