﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace KsiegaGosci
{
    public partial class Default : System.Web.UI.Page
    {
        const string nazwaZmiennej_Wpisy = "Wpisy";

        protected void Page_Load(object sender, EventArgs e)
        {
            if (Application[nazwaZmiennej_Wpisy] == null) Application.Add(nazwaZmiennej_Wpisy, new List<string>());
            else WyświetlanieWpisów();
        }

        private void WyświetlanieWpisów()
        {
            List<string> wpisy = (List<string>)Application[nazwaZmiennej_Wpisy];
            
            string trescWpisow = "";
            foreach (string wpis in wpisy) trescWpisow += wpis;
            Label1.Text = trescWpisow;
        }

        const string kolorParzysty = "navy";
        const string kolorNieparzysty = "blue";

        private string KolorNagłówka(int numerWpisu)
        {
            return (numerWpisu % 2 == 0) ? kolorParzysty : kolorNieparzysty;
        }

        protected void Button1_Click(object sender, EventArgs e)
        {
            if (TextBox1.Text == "" || TextBox2.Text == "") return; //walidacja po stronie serwera

            //ustalanie treści wpisu
            List<string> wpisy = (List<string>)Application[nazwaZmiennej_Wpisy];
            string nagłówek = "<FONT COLOR='" + KolorNagłówka(wpisy.Count) + "'><B> Dodano dnia " + DateTime.Now.ToString() + "</B></FONT>";
            string treść = TextBox2.Text.Trim().Replace("\n", "<BR>");
            string podpis = "<I>" + TextBox1.Text.Trim() + "</I> (" + this.Request.UserHostAddress + ")";

            //dodawanie wpisu
            string nowyWpis = nagłówek + "<BR>" + treść + "<BR>" + podpis + "<P>";
            nowyWpis += "<HR WIDTH='30%' ALIGN='left'>";
            wpisy.Add(nowyWpis);
            
            //wyświetlanie wpisów
            WyświetlanieWpisów();

            TextBox2.Text = ""; //czyszczenie pola edycyjnego z treścią wpisu
        }
    }
}