﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

using System.IO;

using Okno = System.Windows.Forms.Form;

namespace NotatnikNET
{
    public partial class Form1 : Form
    {
        string nazwaPliku = "";

        public Form1()
        {
            InitializeComponent();
        }

        private void zakończToolStripMenuItem_Click(object sender, EventArgs e)
        {
            Close();
        }

        private void pasekStanuToolStripMenuItem_Click(object sender, EventArgs e)
        {
            pasekStanuToolStripMenuItem.Checked = !pasekStanuToolStripMenuItem.Checked;
            statusStrip1.Visible = pasekStanuToolStripMenuItem.Checked;
        }

        private void czcionkaToolStripMenuItem_Click(object sender, EventArgs e)
        {
            fontDialog1.Font = textBox1.Font;
            fontDialog1.Color = textBox1.ForeColor;
            DialogResult dr = fontDialog1.ShowDialog();
            if (dr == DialogResult.OK)
            {
                textBox1.Font = fontDialog1.Font;
                textBox1.ForeColor = fontDialog1.Color;
            }
        }

        private void kolorTłaToolStripMenuItem_Click(object sender, EventArgs e)
        {
            colorDialog1.Color = textBox1.BackColor;
            if (colorDialog1.ShowDialog() == DialogResult.OK)
            {
                textBox1.BackColor = colorDialog1.Color;
            }
        }

        private void zawijanieWierszyToolStripMenuItem_Click(object sender, EventArgs e)
        {
            zawijanieWierszyToolStripMenuItem.Checked = !zawijanieWierszyToolStripMenuItem.Checked;
            textBox1.WordWrap = zawijanieWierszyToolStripMenuItem.Checked;
            textBox1.ScrollBars = (textBox1.WordWrap) ? ScrollBars.Vertical : ScrollBars.Both;
        }

        private void cofnijToolStripMenuItem_Click(object sender, EventArgs e)
        {
            textBox1.Undo();
        }

        private void textBox1_TextChanged(object sender, EventArgs e)
        {
        }

        private void wytnijToolStripMenuItem_Click(object sender, EventArgs e)
        {
            textBox1.Cut();
        }

        private void kopiujToolStripMenuItem_Click(object sender, EventArgs e)
        {
            textBox1.Copy();
        }

        private void wklejToolStripMenuItem_Click(object sender, EventArgs e)
        {
            textBox1.Paste();
        }

        private void usuńToolStripMenuItem_Click(object sender, EventArgs e)
        {
            textBox1.SelectedText = "";
        }

        private void zaznaczWszystkoToolStripMenuItem_Click(object sender, EventArgs e)
        {
            textBox1.SelectAll();
        }

        private void godzinaDataToolStripMenuItem_Click(object sender, EventArgs e)
        {
            string godzina_data = DateTime.Now.ToString();

            /*
            //w ramach rozpaczy!!!!!
            textBox1.Text = 
                textBox1.Text.Substring(0, textBox1.SelectionStart) + 
                godzina_data + 
                textBox1.Text.Substring(textBox1.SelectionStart);
            */

            StringBuilder sb = new StringBuilder(textBox1.Text);
            sb.Insert(textBox1.SelectionStart, godzina_data);
            textBox1.Text = sb.ToString();
        }

        private void nowyToolStripMenuItem_Click(object sender, EventArgs e)
        {
            textBox1.Text = "";
        }

        public static string[] CzytajPlikTekstowy(string nazwaPliku)
        {
            try
            {
                List<string> tekst = new List<string>();
                using (System.IO.StreamReader sr = new System.IO.StreamReader(nazwaPliku))
                {
                    string wiersz;
                    while ((wiersz = sr.ReadLine()) != null)
                        tekst.Add(wiersz);                    
                }
                return tekst.ToArray();
            }
            catch(Exception exc)
            {
                MessageBox.Show(
                    "Błąd odczytu pliku " + 
                    nazwaPliku + " (" + exc.Message + ")");
                return null;
            }
        }

        private void otwórzToolStripMenuItem_Click(object sender, EventArgs e)
        {
            if (openFileDialog1.ShowDialog() == DialogResult.OK)
            {
                nazwaPliku=openFileDialog1.FileName;
                textBox1.Lines=CzytajPlikTekstowy(nazwaPliku);
                toolStripStatusLabel1.Text = nazwaPliku;
            }
        }

        public static bool ZapiszDoPlikuTekstowego(string nazwaPliku, string[] tekst)
        {
            try
            {
                using (StreamWriter sw = new StreamWriter(nazwaPliku))
                {
                    foreach (string wiersz in tekst)
                        sw.WriteLine(wiersz);
                }
                return true;
            }
            catch (Exception exc)
            {
                MessageBox.Show("Błąd w zapisie do pliku " + nazwaPliku + " (" + exc.Message + ")");
                return false;
            }
        }

        private void zapiszJakoToolStripMenuItem_Click(object sender, EventArgs e)
        {
            saveFileDialog1.Filter = openFileDialog1.Filter;
            saveFileDialog1.FileName = openFileDialog1.FileName;
            if (saveFileDialog1.ShowDialog() == DialogResult.OK)
            {
                nazwaPliku = saveFileDialog1.FileName;
                ZapiszDoPlikuTekstowego(
                    nazwaPliku,
                    textBox1.Lines);
                toolStripStatusLabel1.Text = nazwaPliku;
            }
        }

        private void zapiszToolStripMenuItem_Click(object sender, EventArgs e)
        {
            if (nazwaPliku == "") zapiszJakoToolStripMenuItem_Click(sender, e);
            else ZapiszDoPlikuTekstowego(nazwaPliku, textBox1.Lines);
        }

        private StringReader sr = null;

        private void printDocument1_PrintPage(object sender, System.Drawing.Printing.PrintPageEventArgs e)
        {
            Font czcionka = textBox1.Font;
            int wysokoscWiersza = (int)czcionka.GetHeight(e.Graphics);
            int iloscLinii = e.MarginBounds.Height / wysokoscWiersza;

            //if (sr == null) sr = new StringReader(textBox1.Text); //na pierwszej stronie
            if (sr == null)
            {
                string tekst = ""; //dodatkowy bufor
                foreach (string wiersz in textBox1.Lines)
                {
                    float szerokoscLinii = e.Graphics.MeasureString(wiersz, czcionka).Width;
                    if (szerokoscLinii < e.MarginBounds.Width)
                    {
                        tekst += wiersz + "\n";
                    }
                    else
                    {
                        float sredniaSzerokoscLitery = 
                            szerokoscLinii / wiersz.Length;
                        int ileLiterWWierszu = 
                            (int)(e.MarginBounds.Width / sredniaSzerokoscLitery);

                        /*
                        //Dzielenie na linie
                        int ileRazy = wiersz.Length / ileLiterWWierszu;
                        for (int i = 0; i < ileRazy; ++i)
                        {
                            tekst += 
                                wiersz.Substring(i * ileLiterWWierszu, ileLiterWWierszu) + "\n";
                        }
                        tekst += wiersz.Substring(ileRazy * ileLiterWWierszu) + "\n";
                        */

                        //Dzielenie na linie ze spacjami
                        string skracanyWiersz = wiersz;
                        do
                        {
                            int ostatniaSpacja = 
                                skracanyWiersz.Substring(0, ileLiterWWierszu).LastIndexOf(' ');
                            int iloscLiter = 
                                ostatniaSpacja != -1 ? Math.Min(ostatniaSpacja, ileLiterWWierszu) : ileLiterWWierszu;
                            tekst += skracanyWiersz.Substring(0, iloscLiter) + "\n";
                            skracanyWiersz = skracanyWiersz.Substring(iloscLiter).TrimStart(' ');

                        } while (skracanyWiersz.Length > ileLiterWWierszu);
                        tekst += skracanyWiersz + "\n";
                    }
                }
                sr = new StringReader(tekst);
            }
            e.HasMorePages = true;

            for (int i = 0; i < iloscLinii; ++i)
            {
                string wiersz = sr.ReadLine();
                if (wiersz == null)
                {
                    e.HasMorePages = false;
                    sr = null;
                    break;
                }
                else
                {
                    e.Graphics.DrawString(
                        wiersz,
                        czcionka,
                        Brushes.Black,
                        e.MarginBounds.Left,
                        e.MarginBounds.Top + i * wysokoscWiersza);
                }
            }
        }

        private void toolStripMenuItem8_Click(object sender, EventArgs e)
        {
            if (printDialog1.ShowDialog() == DialogResult.OK)
            {
                printDocument1.DocumentName = "Notatnik.NET - " + nazwaPliku;
                printDocument1.Print();
            }
        }

        private void toolStripMenuItem6_Click(object sender, EventArgs e)
        {
            pageSetupDialog1.ShowDialog();
        }

        private void toolStripMenuItem7_Click(object sender, EventArgs e)
        {
            printPreviewDialog1.ShowDialog();
        }
    }
}
