﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace AplikacjaBazodanowa2
{
    public partial class Form1 : Form
    {
        bool czyDaneZmienione = false;

        public Form1()
        {
            InitializeComponent();
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            // TODO: This line of code loads data into the 'kursVDataSet.Osoby' table. You can move, or remove it, as needed.
            this.osobyTableAdapter.Fill(this.kursVDataSet.Osoby);
            czyDaneZmienione = false;
        }

        private void button1_Click(object sender, EventArgs e)
        {
            this.Validate();
            osobyBindingSource.EndEdit();
            osobyTableAdapter.Update(kursVDataSet.Osoby);
            czyDaneZmienione = false;
        }

        private void dataGridView1_CellValueChanged(object sender, DataGridViewCellEventArgs e)
        {
            czyDaneZmienione = true;
        }

        private void Form1_FormClosing(object sender, FormClosingEventArgs e)
        {
            if(!czyDaneZmienione) return;

            DialogResult dr=MessageBox.Show(
                "Czy zapisać zmienione dane?",
                "Zapis danych",
                MessageBoxButtons.YesNoCancel,
                MessageBoxIcon.Question,
                MessageBoxDefaultButton.Button3);

            switch (dr)
            {
                case DialogResult.Cancel: 
                    e.Cancel = true; 
                    break;
                case DialogResult.Yes:
                    button1_Click(null, null);
                    //Close();
                    break;
                case DialogResult.No:
                    //Close();
                    break;
            }
        }

        private void button2_Click(object sender, EventArgs e)
        {
            var osobyMniej30 = from osoba in kursVDataSet.Osoby
                               where osoba.Wiek<30
                               orderby osoba.Nazwisko descending
                               select osoba.Imię + " " + osoba.Nazwisko;

            string s = "Osoby, wiek < 30\n";
            foreach (var osoba in osobyMniej30)
            {
                s += osoba + "\n";
            }
            MessageBox.Show(s);
        }

        private void button3_Click(object sender, EventArgs e)
        {
            var osobyMniej30 = from osoba in kursVDataSet.Osoby
                               //where osoba.Wiek > 25
                               orderby osoba.Nazwisko descending
                               select osoba;

            string s = "Osoby, wiek < 25\n";
            foreach (var osoba in osobyMniej30)
            {
                s += osoba.Imię + " " + osoba.Nazwisko + "\n";
                osoba.Wiek += 10;
            }
            MessageBox.Show(s);


            int wiekMaksymalny = osobyMniej30.Min( (osoba) => osoba.Wiek );
            MessageBox.Show(wiekMaksymalny.ToString());

            double wiekSredni = osobyMniej30.Average((osoba) => osoba.Wiek);
            MessageBox.Show(wiekSredni.ToString());
        }
    }
}
