﻿using DeliveryHelper.Common;

using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Runtime.InteropServices.WindowsRuntime;
using Windows.ApplicationModel.Resources;
using Windows.Foundation;
using Windows.Foundation.Collections;
using Windows.Graphics.Display;
using Windows.UI.Core;
using Windows.UI.ViewManagement;
using Windows.UI.Xaml;
using Windows.UI.Xaml.Controls;
using Windows.UI.Xaml.Controls.Primitives;
using Windows.UI.Xaml.Data;
using Windows.UI.Xaml.Input;
using Windows.UI.Xaml.Media;
using Windows.UI.Xaml.Media.Imaging;
using Windows.UI.Xaml.Navigation;

using Windows.UI.Xaml.Controls.Maps;
using Windows.UI.Xaml.Shapes;
using DeliveryHelper.Model;
using Windows.UI;
using Windows.Devices.Geolocation;
using WinRTXamlToolkit.Controls.DataVisualization.Charting;

// The Universal Hub Application project template is documented at http://go.microsoft.com/fwlink/?LinkID=391955

namespace DeliveryHelper
{
    /// <summary>
    /// A page that displays a grouped collection of items.
    /// </summary>
    public sealed partial class HubPage : Page
    {
        private readonly NavigationHelper navigationHelper;
        private readonly ObservableDictionary defaultViewModel = new ObservableDictionary();
        //private readonly ResourceLoader resourceLoader = ResourceLoader.GetForCurrentView("Resources");

        public HubPage()
        {
            this.InitializeComponent();

            // Hub is only supported in Portrait orientation
            DisplayInformation.AutoRotationPreferences = DisplayOrientations.Portrait;

            this.NavigationCacheMode = NavigationCacheMode.Required;

            this.navigationHelper = new NavigationHelper(this);
            this.navigationHelper.LoadState += this.NavigationHelper_LoadState;
            this.navigationHelper.SaveState += this.NavigationHelper_SaveState;
        }

        /// <summary>
        /// Gets the <see cref="NavigationHelper"/> associated with this <see cref="Page"/>.
        /// </summary>
        public NavigationHelper NavigationHelper
        {
            get { return this.navigationHelper; }
        }

        /// <summary>
        /// Gets the view model for this <see cref="Page"/>.
        /// This can be changed to a strongly typed view model.
        /// </summary>
        public ObservableDictionary DefaultViewModel
        {
            get { return this.defaultViewModel; }
        }

        /// <summary>
        /// Populates the page with content passed during navigation.  Any saved state is also
        /// provided when recreating a page from a prior session.
        /// </summary>
        /// <param name="sender">
        /// The source of the event; typically <see cref="NavigationHelper"/>
        /// </param>
        /// <param name="e">Event data that provides both the navigation parameter passed to
        /// <see cref="Frame.Navigate(Type, object)"/> when this page was initially requested and
        /// a dictionary of state preserved by this page during an earlier
        /// session.  The state will be null the first time a page is visited.</param>
        private async void NavigationHelper_LoadState(object sender, LoadStateEventArgs e)
        {
            this.DefaultViewModel["DeliveriesActive"] = DataHelper.Active;
            this.DefaultViewModel["DeliveriesDelayed"] = DataHelper.Delayed;
            this.DefaultViewModel["DeliveriesCompleted"] = DataHelper.Completed;
            this.defaultViewModel["ListsCounts"] = DataHelper.ListCounts;
        }

        /// <summary>
        /// Preserves state associated with this page in case the application is suspended or the
        /// page is discarded from the navigation cache.  Values must conform to the serialization
        /// requirements of <see cref="SuspensionManager.SessionState"/>.
        /// </summary>
        /// <param name="sender">The source of the event; typically <see cref="NavigationHelper"/></param>
        /// <param name="e">Event data that provides an empty dictionary to be populated with
        /// serializable state.</param>
        private void NavigationHelper_SaveState(object sender, SaveStateEventArgs e)
        {
            // TODO: Save the unique state of the page here.
        }

        /// <summary>
        /// Shows the details of a clicked group in the <see cref="SectionPage"/>.
        /// </summary>
        /// <param name="sender">The source of the click event.</param>
        /// <param name="e">Details about the click event.</param>
        //private void GroupSection_ItemClick(object sender, ItemClickEventArgs e)
        //{
        //    var groupId = ((SampleDataGroup)e.ClickedItem).UniqueId;
        //    if (!Frame.Navigate(typeof(SectionPage), groupId))
        //    {
        //        throw new Exception(this.resourceLoader.GetString("NavigationFailedExceptionMessage"));
        //    }
        //}

        ///// <summary>
        ///// Shows the details of an item clicked on in the <see cref="ItemPage"/>
        ///// </summary>
        ///// <param name="sender">The source of the click event.</param>
        ///// <param name="e">Defaults about the click event.</param>
        //private void ItemView_ItemClick(object sender, ItemClickEventArgs e)
        //{
        //    var itemId = ((SampleDataItem)e.ClickedItem).UniqueId;
        //    if (!Frame.Navigate(typeof(ItemPage), itemId))
        //    {
        //        throw new Exception(this.resourceLoader.GetString("NavigationFailedExceptionMessage"));
        //    }
        //}

        #region NavigationHelper registration

        /// <summary>
        /// The methods provided in this section are simply used to allow
        /// NavigationHelper to respond to the page's navigation methods.
        /// <para>
        /// Page specific logic should be placed in event handlers for the
        /// <see cref="NavigationHelper.LoadState"/>
        /// and <see cref="NavigationHelper.SaveState"/>.
        /// The navigation parameter is available in the LoadState method
        /// in addition to page state preserved during an earlier session.
        /// </para>
        /// </summary>
        /// <param name="e">Event data that describes how this page was reached.</param>
        protected override void OnNavigatedTo(NavigationEventArgs e)
        {
            Windows.Phone.UI.Input.HardwareButtons.BackPressed += OnBackKeyPress;
            this.navigationHelper.OnNavigatedTo(e);
        }

        protected override void OnNavigatedFrom(NavigationEventArgs e)
        {
            this.navigationHelper.OnNavigatedFrom(e);
        }

        #endregion


        private void CompletedButton_Click(object sender, RoutedEventArgs e)
        {
            var btn = sender as Button;

            var element = sender as FrameworkElement;
            var Delivery = element.DataContext as Delivery;

            DataHelper.CompletedDelivery(Delivery);
            this.Poper.IsOpen = false;
            //RefreshCharts();
        }

        private void DelayButton_Click(object sender, RoutedEventArgs e)
        {
            var element = sender as FrameworkElement;
            var Delivery = element.DataContext as Delivery;

            DataHelper.DelayDelivery(Delivery);
            this.Poper.IsOpen = false;
            //RefreshCharts();
        }

        private void RestoreButton_Click(object sender, RoutedEventArgs e)
        {
            var element = sender as FrameworkElement;
            var Delivery = element.DataContext as Delivery;

            DataHelper.RestoreDelivery(Delivery);
            this.Poper.IsOpen = false;
            //RefreshCharts();
        }

        private void CallButton_Click(object sender, RoutedEventArgs e)
        {
            var element = sender as FrameworkElement;
            var Delivery = element.DataContext as Delivery;

            if (Delivery.ContactNumber != null)
            {
                Windows.ApplicationModel.Calls.PhoneCallManager.ShowPhoneCallUI(Delivery.ContactNumber, Delivery.ContactInfo);
            }
        }

        private async void PrzeliczButton_Click(object sender, RoutedEventArgs e)
        {
            DeliveryMapHelper.Instance.SetShortestRouteOrder();
        }

        private async void UstawButton_Click(object sender, RoutedEventArgs e)
        {
            await DeliveryMapHelper.Instance.RegisterFence();
        }

        private void Map_Loaded(object sender, RoutedEventArgs e)
        {
            UniversalMap Map = sender as UniversalMap;
            DeliveryMapHelper.Instance.Map = Map;
            Map.Register("G3n_KELEzbqOR29aqrKbVA");

        }

        void DeliveryClick(object sender, ItemClickEventArgs e)
        {
            Delivery ClickedDelivery = e.ClickedItem as Delivery;
            this.PopupGrid.Width = Window.Current.Bounds.Width;
            this.PopupGrid.Height = Window.Current.Bounds.Height;

            this.Poper.DataContext = e.ClickedItem;

            if (ClickedDelivery.ContactNumber != null && ClickedDelivery.ContactNumber != "")
            {
                this.CallButton.IsEnabled = true;
            }
            else
            {
                this.CallButton.IsEnabled = false;
            }

            switch (ClickedDelivery.State)
            {
                case State.Active:
                    enableButton(CompletedButton);
                    enableButton(DelayButton);
                    disableButton(RestoreButton);
                    disableButton(RemoveButton);
                    break;
                case State.Completed:
                    disableButton(CompletedButton);
                    disableButton(DelayButton);
                    enableButton(RestoreButton);
                    enableButton(RemoveButton);
                    break;
                case State.Delayed:
                    enableButton(CompletedButton);
                    disableButton(DelayButton);
                    enableButton(RestoreButton);
                    disableButton(RemoveButton);
                    break;
            }

            this.Poper.IsOpen = true;
        }

        private void disableButton(Button B)
        {
            B.IsEnabled = false;
            Image image = B.Content as Image;
            image.Opacity = 0.3;
        }

        private void enableButton(Button B)
        {
            B.IsEnabled = true;
            Image image = B.Content as Image;
            image.Opacity = 1.0;
        }


        public void OnBackKeyPress(object sender, Windows.Phone.UI.Input.BackPressedEventArgs args)
        {
            if (this.Poper.IsOpen)
            {
                this.Poper.IsOpen = false;
                args.Handled = true;
            }

            //base.OnBackKeyPress(e);
        }

        private void GFenceText_Loaded(object sender, RoutedEventArgs e)
        {
            TextBox TB = sender as TextBox;
            DeliveryMapHelper.Instance.GeofenceInfo = TB;
            TB.Text = "Loaded";
        }

        private void PieSeries_SelectionChanged(object sender, SelectionChangedEventArgs e)
        {

        }
                
        private Chart Chart;
        private void Chart_Loaded(object sender, RoutedEventArgs e)
        {
            Chart = sender as Chart;
        }

        private void ColumnSeries_Loaded(object sender, RoutedEventArgs e)
        {
            LinearAxis LAxis = (Chart.ActualAxes[1] as LinearAxis);

            if (LAxis == null)
                LAxis = (Chart.ActualAxes[0] as LinearAxis);

            if (LAxis != null)
            {
                LAxis.Interval = 1.0;
                LAxis.Minimum = 0.0;
                LAxis.ShowGridLines = true;
                //var Setters = LAxis.GridLineStyle.Setters;
                //Setters.Add(new Setter(Line.StrokeProperty, "Black"));
                //Setters.Add(new Setter(Line.StrokeThicknessProperty, 1));
                ////x.Add(new Setter(Line.OpacityProperty, 0.4));
                //Setters.Add(new Setter(Line.StrokeDashArrayProperty, "6,4"));
            }
        }

        private Chart PieChart;
        private void PieChart_Loaded(object sender, RoutedEventArgs e)
        {
            PieChart = sender as Chart;
            (PieChart.Series[0] as PieSeries).ItemsSource = DataHelper.ListCounts;

        }

        private void RemoveButton_DoubleTapped(object sender, DoubleTappedRoutedEventArgs e)
        {
            var element = sender as FrameworkElement;
            var Delivery = element.DataContext as Delivery;

            DataHelper.DeleteDelivery(Delivery);
            this.Poper.IsOpen = false;
        }

        TextBox AddDestination, AddContactInfo, AddContactNumber, AddOrderNo;

        private void AddNewForm_Loaded(object sender, RoutedEventArgs e)
        {
            var element = sender as StackPanel;
            foreach (var Cc in element.Children)
            {
                var Tbox = Cc as TextBox;
                if (Tbox != null)
                {
                    switch (Tbox.Text)
                    {
                        case "AddDestination":
                            AddDestination = Tbox;
                            break;
                        case "AddContactInfo":
                            AddContactInfo = Tbox;
                            break;
                        case "AddContactNumber":
                            AddContactNumber = Tbox;
                            break;
                        case "AddOrderNo":
                            AddOrderNo = Tbox;
                            break;
                        default:
                            break;
                    }
                    Tbox.Text = "";
                }
            }
        }

        private void DodajButton_Clicked(object sender, RoutedEventArgs e)
        {
            Delivery Del = new Delivery();
            Del.Destination = AddDestination.Text;
            Del.ContactInfo = AddContactInfo.Text;
            Del.ContactNumber = AddContactNumber.Text;
            Del.Date = DateTime.Now;
            Del.OrderNo = AddOrderNo.Text;

            DataHelper.AddNewDelivery(Del);
        }
    }
}