﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Graf
{
    public class Graf<T>
    {
        public List<Wierzcholek<T>> V1 = new List<Wierzcholek<T>>();
        public List<Wierzcholek<T>> V2 = new List<Wierzcholek<T>>();

        public int[,] MV;

        public List<Krawedz<T>> K = new List<Krawedz<T>>();

        public List<Tuple<Tuple<int, int>, int>> SudokuZabronione = new List<Tuple<Tuple<int, int>, int>>();


        public Graf<T> KopiaDlaSudoku()
        {
            Graf<T> kopia = new Graf<T>();

            foreach (Wierzcholek<T> v in V1)
            {
                kopia.V1.Add(new Wierzcholek<T>(V1.ElementAt(kopia.V1.Count).wartosc));
                kopia.V1.ElementAt(kopia.V1.Count - 1).sudoku = V1.ElementAt(kopia.V1.Count - 1).sudoku;
            }

            kopia.K = new List<Krawedz<T>>();

            foreach (Krawedz<T> kk in K)
            {
                Wierzcholek<T> vv1 = kopia.V1.Find(wrz => wrz.wartosc.Equals(kk.poczatek.wartosc));
                Wierzcholek<T> vv2 = kopia.V1.Find(wrz => wrz.wartosc.Equals(kk.koniec.wartosc));

                kopia.K.Add(new Krawedz<T>(vv1, vv2));
            }


            kopia.SudokuZabronione = new List<Tuple<Tuple<int, int>, int>>(this.SudokuZabronione);


            return kopia;
        }



        public void DodajKrawedz(Wierzcholek<T> w1, Wierzcholek<T> w2, bool skojarzenie = false, bool skierowana = false, int waga = 0)
        {
            K.Add(new Krawedz<T>(w1, w2, skojarzenie, waga));

            if (!skierowana)
                K.Add(new Krawedz<T>(w2, w1, skojarzenie, waga));

        }

        public void DodajKrawedz(T v1, T v2, bool skojarzenie = false, bool skierowana = false, int waga = 0)
        {
            DodajKrawedz(ZnajdzWierzcholek(v1), ZnajdzWierzcholek(v2), skojarzenie, skierowana, waga);
        }

        public void DodajKrawedz(Krawedz<T> k)
        {
            K.Add(k);
        }

        public void DodajWierzcholek(T wartosc, int grupa = 1)
        {
            if (grupa == 1)
                V1.Add(new Wierzcholek<T>(wartosc));
            else
                V2.Add(new Wierzcholek<T>(wartosc));
        }

        public Wierzcholek<T> ZnajdzWierzcholek(T w)
        {
            foreach (Wierzcholek<T> v in V1)
            {
                if (v.wartosc.Equals(w))
                    return v;
            }

            foreach (Wierzcholek<T> v in V2)
            {
                if (v.wartosc.Equals(w))
                    return v;
            }

            return null;
        }

        public Krawedz<T> ZnajdzKrawedz(Wierzcholek<T> v1, Wierzcholek<T> v2)
        {
            foreach (Krawedz<T> k in K)
            {
                if (k.poczatek == v1 && k.koniec == v2)
                    return k;
            }

            return null;
        }

        public void UsunKrawedz(Wierzcholek<T> v1, Wierzcholek<T> v2, bool skierowana = true)
        {
            for (int i = 0; i < K.Count; i++)
            {
                if (K[i].poczatek == v1 && K[i].koniec == v2)
                {
                    K.Remove(K[i]);
                    i--;
                }
            }

            if (skierowana == false)
            {
                for (int i = 0; i < K.Count; i++)
                {
                    if (K[i].poczatek == v2 && K[i].koniec == v1)
                    {
                        K.Remove(K[i]);
                        i--;
                    }
                }
            }

        }

        public List<Wierzcholek<T>> ZnajdzWolne(int v_num = 0) //tutaj wolne to V1+V2 bez podania v_num!
        {
            List<Wierzcholek<T>> wolne;
            switch (v_num)
            {
                case 0:
                    wolne = new List<Wierzcholek<T>>(V1);
                    wolne.AddRange(V2);
                    break;
                case 1:
                    wolne = new List<Wierzcholek<T>>(V1);
                    break;
                default:
                    wolne = new List<Wierzcholek<T>>(V2);
                    break;
            }


            foreach (Krawedz<T> k in K)
            {
                if (k.Skojarzenie == true)
                {
                    wolne.Remove(k.poczatek);
                    wolne.Remove(k.koniec);
                }
            }

            return wolne;
        }

        public List<Wierzcholek<T>> ZnajdzSkojarzone(int v_num = 0)
        {
            List<Wierzcholek<T>> skojarzone = new List<Wierzcholek<T>>();
            bool ifv1 = false;
            bool ifv2 = false;
            switch (v_num)
            {
                case 0:
                    ifv1 = true;
                    ifv2 = true;
                    break;
                case 1:
                    ifv1 = true;
                    break;
                default:
                    ifv2 = true;
                    break;
            }

            if (ifv1)
            {
                skojarzone.AddRange(V1);

                List<Wierzcholek<T>> wolneV1 = ZnajdzWolne(1);

                skojarzone = skojarzone.Where(v => !wolneV1.Contains(v)).ToList();
            }

            if (ifv2)
            {
                skojarzone.AddRange(V2);

                List<Wierzcholek<T>> wolneV2 = ZnajdzWolne(2);

                skojarzone = skojarzone.Where(v => !wolneV2.Contains(v)).ToList();
            }


            return skojarzone;
        }

        public List<Wierzcholek<T>> Sasiedzi(Wierzcholek<T> wierzcholek)
        {
            List<Wierzcholek<T>> sasiedzi = new List<Wierzcholek<T>>();

            foreach (Krawedz<T> k in K)
            {
                if (k.poczatek == wierzcholek)
                    sasiedzi.Add(k.koniec);
            }

            return sasiedzi;
        }

        public List<Wierzcholek<T>> WolniSasiedzi(Wierzcholek<T> wierzcholek)
        {
            List<Wierzcholek<T>> sasiedzi = Sasiedzi(wierzcholek);

            List<Wierzcholek<T>> wolne = ZnajdzWolne();

            List<Wierzcholek<T>> wolniSasiedzi = sasiedzi.Where(s => wolne.Contains(s)).ToList();

            return wolniSasiedzi;
        }

        public List<Wierzcholek<T>> SkojarzeniSasiedzi(Wierzcholek<T> wierzcholek)
        {
            List<Wierzcholek<T>> sasiedzi = Sasiedzi(wierzcholek);

            List<Wierzcholek<T>> wolne = ZnajdzWolne();

            List<Wierzcholek<T>> skojarzeniSasiedzi = sasiedzi.Where(s => !wolne.Contains(s)).ToList();

            return skojarzeniSasiedzi;
        }




        public List<Krawedz<T>> ListaWierzcholkowToListaKrawedzi(List<Wierzcholek<T>> LW)
        {
            List<Krawedz<T>> LK = new List<Krawedz<T>>();

            if (LW.Count < 2)
                return null;

            for (int i = 0; i < LW.Count - 1; i++)
            {
                Krawedz<T> kk = ZnajdzKrawedz(LW.ElementAt(i), LW.ElementAt(i + 1));
                if (kk == null)
                {
                    string error = "Nie znaleziono krawedzi, zla lista wierzcholkow.";
                    return null;
                }
                else
                {
                    LK.Add(kk);
                }


            }

            return LK;
        }


        // Metoda przeksztalca reprezentacje krawedzi z listy w macierz.
        // Macierz NIE jest aktualizowana na biezaco
        // Tylko do uzytku w grafach nie-dwudzielnych (do nich bedzie inna metoda? albo i nie bedzie wcale)
        public void CreateMatrix()
        {
            int size = V1.Count;

            MV = new int[size, size];

            for (int i = 0; i < size; i++)
                for (int j = 0; j < size; j++)
                {
                    if (i != j)
                    {
                        Krawedz<T> kr = ZnajdzKrawedz(V1[i], V1[j]);
                        if (kr != null)
                            MV[i, j] = kr.waga;
                        else
                            MV[i, j] = -1;
                        //M[i, j] = int.MaxValue;
                    }
                    else
                    {
                        //M[i, j] = int.MaxValue;
                        MV[i, j] = -1;
                    }
                }
        }




        //private void WypiszMAlgW(int[,] M)
        //{
        //    int n = M.Length;
        //    n = (int)System.Math.Sqrt(n);

        //    Console.WriteLine("");
        //    for (int i = 0; i < n; i++)
        //    {
        //        for (int j = 0; j < n; j++)
        //        {
        //            if (i == n-1 || j == n-1)
        //            {
        //                if(M[i, j] != 0)
        //                    Console.Write("{0,4} ", 'x');
        //                else
        //                    Console.Write("{0,4} ", ' ');
        //            }
        //            else
        //                Console.Write("{0,4} ",M[i, j]);
        //        }
        //        Console.WriteLine();
        //    }

        //    Console.WriteLine();
        //}


        public static int ZerujWiersze(int[,] M)
        {
            int s1 = M.GetLength(0);
            int s2 = M.GetLength(1);

            int minValue;
            int lowerBoundDelta = 0;

            for (int i = 0; i < s1; i++)
            {
                minValue = int.MaxValue;

                // znalezienie minimalnej wartosci w wierszu
                for (int j = 0; j < s2; j++)
                {
                    if (M[i, j] < minValue && M[i, j] >= 0)
                        minValue = M[i, j];
                }

                if (minValue == int.MaxValue)
                    minValue = 0;

                lowerBoundDelta += minValue;

                // odjecie wartosci
                for (int j = 0; j < s2; j++)
                {
                    if (M[i, j] > 0 && minValue > 0)
                    {
                        M[i, j] -= minValue;
                    }
                }

            }

            return lowerBoundDelta;
        }

        public static int ZerujKolumny(int[,] M)
        {
            int s1 = M.GetLength(0);
            int s2 = M.GetLength(1);

            int minValue;
            int lowerBoundDelta = 0;

            for (int j = 0; j < s2; j++)
            {
                minValue = int.MaxValue;

                // znalezienie minimalnej wartosci w wierszu
                for (int i = 0; i < s1; i++)
                {
                    if (M[i, j] < minValue && M[i, j] >= 0)
                        minValue = M[i, j];
                }
                if (minValue == int.MaxValue)
                    minValue = 0;

                lowerBoundDelta += minValue;

                // odjecie wartosci
                for (int i = 0; i < s1; i++)
                {
                    if (M[i, j] > 0 && minValue > 0)
                    {
                        M[i, j] -= minValue;
                    }
                }

            }

            return lowerBoundDelta;
        }



        public static void WybierzRozwiazanieAlgW(int[,] m)
        {
            int n = m.GetLength(0) - 1;

            // wybieramy zera
            for (int i = 0; i < n; i++)
            {
                m[i, n] = 0;
                m[n, i] = 0;
            }


            int numzeros;
            int iz1 = 0, iz2 = 0;


            bool zerosExist;

            do
            {

                zerosExist = false;
                for (int j = 0; j < n; j++)
                    for (int i = 0; i < n; i++)
                        if (m[i, j] == 0)
                            zerosExist = true;



                // kolumny z poj. zerami:
                for (int j = 0; j < n; j++)
                {
                    numzeros = 0;
                    for (int i = 0; i < n; i++)
                    {
                        if (m[i, j] == 0)
                        {
                            numzeros++;

                            iz1 = i;
                            iz2 = j;
                        }
                    }

                    if (numzeros == 1)
                    {
                        // wybieramy
                        m[iz1, iz2] = -1;

                        // odrzucamy w wierszu
                        for (int l = 0; l < n; l++)
                        {
                            if (m[iz1, l] == 0)
                                m[iz1, l] = -2;
                        }
                    }
                }
                // wiersze z poj. zerami:
                for (int i = 0; i < n; i++)
                {
                    numzeros = 0;
                    for (int j = 0; j < n; j++)
                    {
                        if (m[i, j] == 0)
                        {
                            numzeros++;

                            iz1 = i;
                            iz2 = j;
                        }
                    }

                    if (numzeros == 1)
                    {
                        // wybieramy
                        m[iz1, iz2] = -1;

                        // odrzucamy w kolumnie
                        for (int k = 0; k < n; k++)
                        {
                            if (m[k, iz2] == 0)
                                m[k, iz2] = -2;
                        }
                    }
                }

            } while (zerosExist);

            for (int j = 0; j < n; j++)
                for (int i = 0; i < n; i++)
                {
                    if (m[i, j] != -1)
                        m[i, j] = 0;
                }

            for (int j = 0; j < n; j++)
                for (int i = 0; i < n; i++)
                {
                    if (m[i, j] == -1)
                        m[i, j] = 1;
                }
        }

        public List<Krawedz<T>> Komiwojazer()
        {
            List<Krawedz<T>> Sciezka = new List<Krawedz<T>>();

            CreateMatrix();

            //PrintMatrix(MV);
            ZerujWiersze(MV);
            //PrintMatrix(MV);
            ZerujKolumny(MV);
            //PrintMatrix(MV);
            // PrintMatrix( Subtablica(MV, 0, 0, 0, 2) );

            int Ax;
            int Ay;

            indMaxSumyWKWZerze(MV, out Ax, out Ay);

            // korzen
            Drzewo<KomiwojazerMLB<T>> tree = new Drzewo<KomiwojazerMLB<T>>(new KomiwojazerMLB<T>(MV, this));

            tree.V.redukuj();

            Drzewo<KomiwojazerMLB<T>> min = znajdzMinLB(tree);

            int BranchW;
            int BranchK;
            int krawedz1, krawedz2;
            Krawedz<T> Kr;

            int LP = 0;

            while (min.V.M.Length > 4)
            {
                min = znajdzMinLB(tree);

                //Console.WriteLine("Min: ");
                //min.V.Print();

                indMaxSumyWKWZerze(min.V.M, out BranchW, out BranchK);

                // 1. - rozwiazanie zawierajace krawedz
                min.DodajDziecko(new Drzewo<KomiwojazerMLB<T>>(new KomiwojazerMLB<T>(min.V, this)));


                krawedz1 = min.Dzieci.ElementAt(0).V.wiersze.ElementAt(BranchW);
                krawedz2 = min.Dzieci.ElementAt(0).V.kolumny.ElementAt(BranchK);

                min.Dzieci.ElementAt(0).V.wiersze.Remove(min.Dzieci.ElementAt(0).V.wiersze.ElementAt(BranchW));
                min.Dzieci.ElementAt(0).V.kolumny.Remove(min.Dzieci.ElementAt(0).V.kolumny.ElementAt(BranchK));

                Kr = ZnajdzKrawedz(V1.ElementAt(krawedz1), V1.ElementAt(krawedz2));

                min.Dzieci.ElementAt(0).V.Zawarte.Add(Kr);
                min.Dzieci.ElementAt(0).V.M = wytnijWK(min.Dzieci.ElementAt(0).V.M, BranchW, BranchK);

                // [j, i]
                int Ind1 = min.Dzieci.ElementAt(0).V.wiersze.FindIndex(x => x == krawedz2);
                int Ind2 = min.Dzieci.ElementAt(0).V.kolumny.FindIndex(x => x == krawedz1);
                if (Ind1 >= 0)
                {
                    if (Ind2 >= 0)
                    {
                        min.Dzieci.ElementAt(0).V.M[Ind1, Ind2] = -1;
                    }
                }
                min.Dzieci.ElementAt(0).V.redukuj();

                // Console.WriteLine("Lewa: ");
                //Console.WriteLine("Usuniete i/j: " + BranchW + "/" + BranchK + " Czyli sciezka " + krawedz1 + "/" + krawedz2);
                //min.Dzieci.ElementAt(0).V.Print();


                // 2. - rozwiazanie nie zawierajace krawedzi                                
                min.DodajDziecko(new Drzewo<KomiwojazerMLB<T>>(new KomiwojazerMLB<T>(min.V, this)));
                min.Dzieci.ElementAt(1).V.Odrzucone.Add(Kr);


                min.Dzieci.ElementAt(1).V.M[BranchW, BranchK] = -1;
                //Console.WriteLine("Prawa: ");
                //min.Dzieci.ElementAt(1).V.Print();
                min.Dzieci.ElementAt(1).V.redukuj();
                //min.Dzieci.ElementAt(1).V.Print();

                //PropagujLB(min);      
            }
            min = znajdzMinLB(tree);

            krawedz1 = min.V.wiersze.ElementAt(0);
            krawedz2 = min.V.kolumny.ElementAt(0);

            min.V.wiersze.Remove(min.V.wiersze.ElementAt(0));
            min.V.kolumny.Remove(min.V.kolumny.ElementAt(0));

            Kr = ZnajdzKrawedz(V1.ElementAt(krawedz1), V1.ElementAt(krawedz2));

            if (Kr != null)
                min.V.Zawarte.Add(Kr);

            Sciezka = min.V.Zawarte;


            return Sciezka;
        }

  
        public int[,] wytnijWK(int[,] M, int w1, int w2)
        {
            int[,] MC;

            int s1 = M.GetLength(0) - 1;
            int s2 = M.GetLength(1) - 1;

            MC = new int[s1, s2];

            int skipWiersz = 0;
            int skipKolumne = 0;
            for (int i = 0; i < s1; i++)
            {
                if (i == w1)
                {
                    skipWiersz = 1;
                }

                skipKolumne = 0;


                //Console.WriteLine("i: " + i);
                for (int j = 0; j < s2; j++)
                {
                    if (j == w2)
                    {
                        skipKolumne = 1;
                    }
                    //Console.WriteLine("j: " + j);

                    MC[i, j] = M[i + skipWiersz, j + skipKolumne];
                }
            }

            return MC;
        }


        public Drzewo<KomiwojazerMLB<T>> znajdzMinLBOld(Drzewo<KomiwojazerMLB<T>> d)
        {
            Drzewo<KomiwojazerMLB<T>> cur = d;
            Drzewo<KomiwojazerMLB<T>> next = d;

            int lb;

            while (cur.Dzieci.Count() > 0)
            {
                lb = int.MaxValue;
                foreach (Drzewo<KomiwojazerMLB<T>> dz in cur.Dzieci)
                {
                    if (dz.V.LowerBound < lb)
                    {
                        lb = dz.V.LowerBound;
                        next = dz;
                    }
                }
                cur = next;
            }

            return cur;
        }


        public Drzewo<KomiwojazerMLB<T>> znajdzMinLB(Drzewo<KomiwojazerMLB<T>> d)
        {
            Drzewo<KomiwojazerMLB<T>> cur = d;
            Drzewo<KomiwojazerMLB<T>> next = d;

            int lb;

            while (cur.Dzieci.Count() > 0)
            {
                lb = int.MaxValue;
                foreach (Drzewo<KomiwojazerMLB<T>> dz in cur.Dzieci)
                {
                    if (dz.V.LowerBound < lb)
                    {
                        lb = dz.V.LowerBound;
                        next = dz;
                    }
                }
                cur = next;
            }

            return cur;
        }

        private void PropagujLB(Drzewo<KomiwojazerMLB<T>> T)
        {
            if (T == null)
                return;

            int newLB = int.MaxValue;
            foreach (var Dziecko in T.Dzieci)
            {
                if (Dziecko.V.LowerBound < newLB)
                    newLB = Dziecko.V.LowerBound;
            }

            if (newLB < int.MaxValue)
                T.V.LowerBound = newLB;

            PropagujLB(T.Rodzic);
        }

        private void indMaxSumyWKWZerze(int[,] M, out int indW, out int indK)
        {
            // szukamy najwiekszej sumy najmniejszych elementow w w. 'i' i kol. 'j'.


            indW = 0;
            indK = 0;

            int max = int.MinValue;

            int s1 = M.GetLength(0);
            int s2 = M.GetLength(1);



            for (int i = 0; i < s1; i++)
            {
                for (int j = 0; j < s2; j++)
                {

                    if (M[i, j] == 0)
                    {
                        int minW = int.MaxValue;
                        int minK = int.MaxValue;
                        for (int k = 0; k < s1; k++)
                        {
                            if (M[k, j] > 0 && M[k, j] < minW)
                                minW = M[k, j];
                        }

                        for (int l = 0; l < s2; l++)
                        {
                            if (M[i, l] > 0 && M[i, l] < minK)
                                minK = M[i, l];
                        }

                        if (max < (minK + minW))
                        {
                            max = minK + minW;

                            indW = i;
                            indK = j;
                        }

                    }



                }
            }


        }

        public double WartoscSciezki(List<Krawedz<T>> Sciezka)
        {
            double Wartosc = 0;

            foreach (var K in Sciezka)
            {
                Wartosc += K.waga;
            }

            return Wartosc;
        }


    } // Graf
}

