﻿using System;
using System.Collections.Generic;
//using System.Text;
using System.Threading.Tasks;
using Windows.Devices.Geolocation;

namespace DeliveryHelper
{
    static class GeolocationHelper
    {
        public static Geolocator _geolocator = new Geolocator() { /*MovementThreshold = 3,*/ /*DesiredAccuracyInMeters = 10*/ };

        public static Geopoint _CurrentPosition = null;
        
        async static public Task<Geopoint> GetPosition()
        {
            Geopoint DefaultLocation = new Geopoint(new BasicGeoposition() { Longitude = 18.5979858, Latitude = 53.0080093 });

            Geopoint Point = null;
            
            Windows.Devices.Geolocation.PositionStatus Status;

            // oczekuje chwile na initialized
            int delayIterations = 0;
            while(_geolocator.LocationStatus == PositionStatus.Initializing || _geolocator.LocationStatus == PositionStatus.NotInitialized)
            {
                Task.Delay(100).Wait();
                delayIterations++;
                if (delayIterations > 10)
                    break;
            }

            try
            {
                Status = _geolocator.LocationStatus;
                switch (Status)
                {
                    case Windows.Devices.Geolocation.PositionStatus.Ready:
                    case Windows.Devices.Geolocation.PositionStatus.NotInitialized:
                    case Windows.Devices.Geolocation.PositionStatus.Initializing:
                        Geoposition GeoPos = await _geolocator.GetGeopositionAsync(TimeSpan.FromMinutes(5), TimeSpan.FromSeconds(60));
                        Point = GeoPos.Coordinate.Point;
                        break;
                    case Windows.Devices.Geolocation.PositionStatus.NoData:
                    case Windows.Devices.Geolocation.PositionStatus.Disabled:
                    case Windows.Devices.Geolocation.PositionStatus.NotAvailable:
                    default:
                        Point = DefaultLocation;
                        break;
                }
            }
            catch (UnauthorizedAccessException ex)
            {
                Point = DefaultLocation;
            }
            catch(Exception ex)
            {
                Point = DefaultLocation;
            }


            _CurrentPosition = Point;
            return Point;
        }
    }
}
