﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using Windows.ApplicationModel.Background;
using Windows.Devices.Geolocation.Geofencing;
using Windows.UI.Xaml;

namespace BackgroundTask
{
    public sealed class GeofencingBackground : IBackgroundTask
    {
        public void Run(IBackgroundTaskInstance taskInstance)
        {
            BackgroundTaskDeferral deferral = taskInstance.GetDeferral();

            var Reports = GeofenceMonitor.Current.ReadReports();
            foreach (var R in Reports)
            {

            }
            deferral.Complete();
        }
    }


    public static class BackgroundTaskRegistering
    {
        public static async void RegisterBackgroundTask(object sender, RoutedEventArgs e)
        {
            BackgroundAccessStatus accessStatus =
              await BackgroundExecutionManager.RequestAccessAsync();
            if (accessStatus ==
              BackgroundAccessStatus.AllowedMayUseActiveRealTimeConnectivity ||
             accessStatus ==
               BackgroundAccessStatus.AllowedWithAlwaysOnRealTimeConnectivity)
            {
                BackgroundTaskBuilder taskBuilder = new BackgroundTaskBuilder();
                taskBuilder.Name = "MyGeoBackground";
                taskBuilder.TaskEntryPoint =
                  "WindowsRuntimeComponent1.MyBackgroundTask";
                LocationTrigger trigger = new LocationTrigger(LocationTriggerType.Geofence);
                taskBuilder.SetTrigger(trigger);
                taskBuilder.Register();
            }
        }
    }


}
