﻿using System.Threading.Tasks;
using Windows.Storage;
using LightsOut;
using MiniLightsOut.Common;
using System;
using Windows.UI.Xaml.Controls;
using Windows.UI.Xaml.Media;
using Windows.UI.Xaml.Navigation;

namespace MiniLightsOut
{

    public partial class PageHighScores : Page
    {
        private readonly ScoreManager _scoreManager = new ScoreManager();
        private readonly NavigationHelper _navigationHelper;

        public NavigationHelper NavigationHelper
        {
            get { return this._navigationHelper; }
        }

        public PageHighScores()
        {
            this.InitializeComponent();
            this._navigationHelper = new NavigationHelper(this);
            ApplicationData.Current.DataChanged += ApplicationData_OnDataChanged;
            PopulateScoreBoard();
        }

        #region Private methods
        private async Task PopulateScoreBoard()
        {
            await _scoreManager.ReadFromFileAsync();
            StackPanelMain.Children.Clear();
            var scores = _scoreManager.TopScores;

            if (scores.Count > 0)
            {
                for (int i = 0; i < scores.Count; i++)
                {
                    var score = scores[i];
                    var timeSpan = new TimeSpan(score.TimeSpanTicks);
                    var text = string.Format("{0,2}. {1} ({2} ruchów w czasie {3:D2}:{4:D2}:{5:D2})",
                        i + 1, score.PlayerName, score.NumberOfMoves, 
                        timeSpan.Minutes, timeSpan.Seconds, (int)(timeSpan.Milliseconds / 10.0));
                    var textBlock = GenerateScoreTextBlock(text);
                    StackPanelMain.Children.Add(textBlock);
                } 
            }
            else
            {
                var textBlock = GenerateScoreTextBlock("Brak najlepszych wyników!");
                StackPanelMain.Children.Add(textBlock);
            }
        }

        private static TextBlock GenerateScoreTextBlock(string text)
        {
            var textBlock = new TextBlock();
            textBlock.FontSize = 24;
            textBlock.Text = text;
            textBlock.FontFamily = new FontFamily("Consolas");
            return textBlock;
        }
        #endregion

        #region NavigationHelper registration
        protected async virtual void ApplicationData_OnDataChanged(ApplicationData sender, object args)
        {
            await PopulateScoreBoard();
        }
        #endregion

        #region Overrides
        protected override void OnNavigatedTo(NavigationEventArgs e)
        {
            _navigationHelper.OnNavigatedTo(e);
        }

        protected override void OnNavigatedFrom(NavigationEventArgs e)
        {
            _navigationHelper.OnNavigatedFrom(e);
        }
        #endregion
    }
}
