﻿using MiniLightsOut.Common;
using Windows.UI.Xaml;
using Windows.UI.Xaml.Controls;
using Windows.UI.Xaml.Navigation;

namespace MiniLightsOut
{
    public sealed partial class PageGame : Page
    {
        private readonly NavigationHelper _navigationHelper;

        public NavigationHelper NavigationHelper
        {
            get { return this._navigationHelper; }
        }

        public PageGame()
        {
            this.InitializeComponent();
            this._navigationHelper = new NavigationHelper(this);
        }

        #region NavigationHelper registration
        protected override void OnNavigatedTo(NavigationEventArgs e)
        {
            GameBoard.PlayerName = (string) e.Parameter;
            _navigationHelper.OnNavigatedTo(e);
            if(e.NavigationMode == NavigationMode.New || e.NavigationMode == NavigationMode.Forward)
                GameBoard.NewGame();
        }

        protected override void OnNavigatedFrom(NavigationEventArgs e)
        {
            _navigationHelper.OnNavigatedFrom(e);
        }
        #endregion

        private void ButtonNewGame_Clicked(object sender, RoutedEventArgs e)
        {
            GameBoard.NewGame();
        }
    }
}
