﻿using System;
using System.Threading.Tasks;
using Windows.UI.Popups;

namespace MiniLightsOut.Helpers
{
    internal static class MessageDialogHelper
    {
        public static async Task<bool> DisplayYesNoDialogAsync(string content, string title = "")
        {
            var messageDialog = new MessageDialog(content, title);
            bool clickedYes = false;

            messageDialog.Commands.Add(new UICommand("Yes", command => clickedYes = true));
            messageDialog.Commands.Add(new UICommand("No"));

            await messageDialog.ShowAsync();

            return clickedYes;
        }
    }
}
