using System.Collections.Generic;
using System.Threading.Tasks;
using LightsOut.Data;

namespace LightsOut.Interfaces
{
    public interface IScoreManager
    {
        /// <summary>
        /// Sorted list containing top scores
        /// </summary>
        IReadOnlyList<PlayerScore> TopScores { get; }

        /// <summary>
        /// Add score to the score list and write changes to file
        /// </summary>
        /// <param name="playerScore">New score to add to the list</param>
        Task AddScoreAsync(PlayerScore playerScore);

        /// <summary>
        /// Write changes to file
        /// </summary>
        /// <param name="fileName">File name to save the changes to</param>
        /// <returns></returns>
        Task WriteToFileAsync(string fileName = "scores.xml");

        /// <summary>
        /// Read changes from file and reaplce current data
        /// </summary>
        /// <param name="fileName">File name to read new score data from</param>
        /// <returns></returns>
        Task ReadFromFileAsync(string fileName = "scores.xml");
    }
}