﻿using System.Collections.Generic;
using System.IO;
using System.Xml.Serialization;
using LightsOut.Data;

namespace LightsOut.Helpers
{
    internal static class Serializer
    {
        /// <summary>
        /// Serialize score list to XML string
        /// </summary>
        /// <param name="scoreList">Score list</param>
        /// <returns>XML string</returns>
        public static string SerializeScoreList(List<PlayerScore> scoreList)
        {
            var serializer = new XmlSerializer(typeof(List<PlayerScore>));
            string outputString;

            using (var stream = new StringWriter())
            {
                serializer.Serialize(stream, scoreList);
                outputString = stream.ToString();
            }

            return outputString;
        }
        
        /// <summary>
        /// Deserialzie XML string to score list
        /// </summary>
        /// <param name="xmlDocument">XML string</param>
        /// <returns>Score list</returns>
        public static List<PlayerScore> DeserializeScoreList(string xmlDocument)
        {
            var serializer = new XmlSerializer(typeof(List<PlayerScore>));
            List<PlayerScore> deserialziedList;

            using (var stream = new StringReader(xmlDocument))
            {
                deserialziedList = (List<PlayerScore>)serializer.Deserialize(stream);
            }

            return deserialziedList;
        }
    }
}
